package org.openqa.selenium.devtools.v144.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AttributionReportingEventLevelResult {

    SUCCESS("success"),
    SUCCESSDROPPEDLOWERPRIORITY("successDroppedLowerPriority"),
    INTERNALERROR("internalError"),
    NOCAPACITYFORATTRIBUTIONDESTINATION("noCapacityForAttributionDestination"),
    NOMATCHINGSOURCES("noMatchingSources"),
    DEDUPLICATED("deduplicated"),
    EXCESSIVEATTRIBUTIONS("excessiveAttributions"),
    PRIORITYTOOLOW("priorityTooLow"),
    NEVERATTRIBUTEDSOURCE("neverAttributedSource"),
    EXCESSIVEREPORTINGORIGINS("excessiveReportingOrigins"),
    NOMATCHINGSOURCEFILTERDATA("noMatchingSourceFilterData"),
    PROHIBITEDBYBROWSERPOLICY("prohibitedByBrowserPolicy"),
    NOMATCHINGCONFIGURATIONS("noMatchingConfigurations"),
    EXCESSIVEREPORTS("excessiveReports"),
    FALSELYATTRIBUTEDSOURCE("falselyAttributedSource"),
    REPORTWINDOWPASSED("reportWindowPassed"),
    NOTREGISTERED("notRegistered"),
    REPORTWINDOWNOTSTARTED("reportWindowNotStarted"),
    NOMATCHINGTRIGGERDATA("noMatchingTriggerData");

    private String value;

    AttributionReportingEventLevelResult(String value) {
        this.value = value;
    }

    public static AttributionReportingEventLevelResult fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingEventLevelResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingEventLevelResult "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingEventLevelResult fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
