package org.openqa.selenium.devtools.v143.runtime;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
 * Evaluation results are returned as mirror object that expose object type, string representation
 * and unique identifier that can be used for further object reference. Original objects are
 * maintained in memory unless they are either explicitly released or are released along with the
 * other objects in their object group.
 */
public class Runtime {

    public static class AwaitPromiseResponse {

        private final org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public AwaitPromiseResponse(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Promise result. Will contain rejected value if promise was rejected.
         */
        public org.openqa.selenium.devtools.v143.runtime.model.RemoteObject getResult() {
            return result;
        }

        /**
         * Exception details if stack strace is available.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static AwaitPromiseResponse fromJson(JsonInput input) {
            org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result = null;
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.read(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject.class);
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new AwaitPromiseResponse(result, exceptionDetails);
        }
    }

    /**
     * Add handler to promise with given promise object id.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.AwaitPromiseResponse> awaitPromise(org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId promiseObjectId, java.util.Optional<java.lang.Boolean> returnByValue, java.util.Optional<java.lang.Boolean> generatePreview) {
        java.util.Objects.requireNonNull(promiseObjectId, "promiseObjectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("promiseObjectId", promiseObjectId);
        returnByValue.ifPresent(p -> params.put("returnByValue", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        return new Command<>("Runtime.awaitPromise", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.AwaitPromiseResponse.class));
    }

    public static class CallFunctionOnResponse {

        private final org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public CallFunctionOnResponse(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Call result.
         */
        public org.openqa.selenium.devtools.v143.runtime.model.RemoteObject getResult() {
            return result;
        }

        /**
         * Exception details.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static CallFunctionOnResponse fromJson(JsonInput input) {
            org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result = null;
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.read(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject.class);
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new CallFunctionOnResponse(result, exceptionDetails);
        }
    }

    /**
     * Calls function with given declaration on the given object. Object group of the result is
     * inherited from the target object.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.CallFunctionOnResponse> callFunctionOn(java.lang.String functionDeclaration, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.CallArgument>> arguments, java.util.Optional<java.lang.Boolean> silent, java.util.Optional<java.lang.Boolean> returnByValue, java.util.Optional<java.lang.Boolean> generatePreview, java.util.Optional<java.lang.Boolean> userGesture, java.util.Optional<java.lang.Boolean> awaitPromise, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> executionContextId, java.util.Optional<java.lang.String> objectGroup, java.util.Optional<java.lang.Boolean> throwOnSideEffect, java.util.Optional<java.lang.String> uniqueContextId, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.SerializationOptions> serializationOptions) {
        java.util.Objects.requireNonNull(functionDeclaration, "functionDeclaration is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("functionDeclaration", functionDeclaration);
        objectId.ifPresent(p -> params.put("objectId", p));
        arguments.ifPresent(p -> params.put("arguments", p));
        silent.ifPresent(p -> params.put("silent", p));
        returnByValue.ifPresent(p -> params.put("returnByValue", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        userGesture.ifPresent(p -> params.put("userGesture", p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", p));
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", p));
        serializationOptions.ifPresent(p -> params.put("serializationOptions", p));
        return new Command<>("Runtime.callFunctionOn", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.CallFunctionOnResponse.class));
    }

    public static class CompileScriptResponse {

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ScriptId> scriptId;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public CompileScriptResponse(java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ScriptId> scriptId, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.scriptId = scriptId;
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Id of the script.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ScriptId> getScriptId() {
            return scriptId;
        }

        /**
         * Exception details.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static CompileScriptResponse fromJson(JsonInput input) {
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ScriptId> scriptId = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "scriptId":
                        scriptId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ScriptId.class));
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new CompileScriptResponse(scriptId, exceptionDetails);
        }
    }

    /**
     * Compiles expression.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.CompileScriptResponse> compileScript(java.lang.String expression, java.lang.String sourceURL, java.lang.Boolean persistScript, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> executionContextId) {
        java.util.Objects.requireNonNull(expression, "expression is required");
        java.util.Objects.requireNonNull(sourceURL, "sourceURL is required");
        java.util.Objects.requireNonNull(persistScript, "persistScript is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("expression", expression);
        params.put("sourceURL", sourceURL);
        params.put("persistScript", persistScript);
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command<>("Runtime.compileScript", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.CompileScriptResponse.class));
    }

    /**
     * Disables reporting of execution contexts creation.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.disable", Map.copyOf(params));
    }

    /**
     * Discards collected exceptions and console API calls.
     */
    public static Command<Void> discardConsoleEntries() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.discardConsoleEntries", Map.copyOf(params));
    }

    /**
     * Enables reporting of execution contexts creation by means of `executionContextCreated` event.
     * When the reporting gets enabled the event will be sent immediately for each existing execution
     * context.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.enable", Map.copyOf(params));
    }

    public static class EvaluateResponse {

        private final org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public EvaluateResponse(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Evaluation result.
         */
        public org.openqa.selenium.devtools.v143.runtime.model.RemoteObject getResult() {
            return result;
        }

        /**
         * Exception details.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static EvaluateResponse fromJson(JsonInput input) {
            org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result = null;
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.read(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject.class);
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new EvaluateResponse(result, exceptionDetails);
        }
    }

    /**
     * Evaluates expression on global object.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.EvaluateResponse> evaluate(java.lang.String expression, java.util.Optional<java.lang.String> objectGroup, java.util.Optional<java.lang.Boolean> includeCommandLineAPI, java.util.Optional<java.lang.Boolean> silent, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> contextId, java.util.Optional<java.lang.Boolean> returnByValue, java.util.Optional<java.lang.Boolean> generatePreview, java.util.Optional<java.lang.Boolean> userGesture, java.util.Optional<java.lang.Boolean> awaitPromise, java.util.Optional<java.lang.Boolean> throwOnSideEffect, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.TimeDelta> timeout, java.util.Optional<java.lang.Boolean> disableBreaks, java.util.Optional<java.lang.Boolean> replMode, java.util.Optional<java.lang.Boolean> allowUnsafeEvalBlockedByCSP, java.util.Optional<java.lang.String> uniqueContextId, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.SerializationOptions> serializationOptions) {
        java.util.Objects.requireNonNull(expression, "expression is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("expression", expression);
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", p));
        silent.ifPresent(p -> params.put("silent", p));
        contextId.ifPresent(p -> params.put("contextId", p));
        returnByValue.ifPresent(p -> params.put("returnByValue", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        userGesture.ifPresent(p -> params.put("userGesture", p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", p));
        timeout.ifPresent(p -> params.put("timeout", p));
        disableBreaks.ifPresent(p -> params.put("disableBreaks", p));
        replMode.ifPresent(p -> params.put("replMode", p));
        allowUnsafeEvalBlockedByCSP.ifPresent(p -> params.put("allowUnsafeEvalBlockedByCSP", p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", p));
        serializationOptions.ifPresent(p -> params.put("serializationOptions", p));
        return new Command<>("Runtime.evaluate", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.EvaluateResponse.class));
    }

    /**
     * Returns the isolate id.
     */
    @Beta()
    public static Command<java.lang.String> getIsolateId() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.getIsolateId", Map.copyOf(params), ConverterFunctions.map("id", java.lang.String.class));
    }

    public static class GetHeapUsageResponse {

        private final java.lang.Number usedSize;

        private final java.lang.Number totalSize;

        private final java.lang.Number embedderHeapUsedSize;

        private final java.lang.Number backingStorageSize;

        public GetHeapUsageResponse(java.lang.Number usedSize, java.lang.Number totalSize, java.lang.Number embedderHeapUsedSize, java.lang.Number backingStorageSize) {
            this.usedSize = java.util.Objects.requireNonNull(usedSize, "usedSize is required");
            this.totalSize = java.util.Objects.requireNonNull(totalSize, "totalSize is required");
            this.embedderHeapUsedSize = java.util.Objects.requireNonNull(embedderHeapUsedSize, "embedderHeapUsedSize is required");
            this.backingStorageSize = java.util.Objects.requireNonNull(backingStorageSize, "backingStorageSize is required");
        }

        /**
         * Used JavaScript heap size in bytes.
         */
        public java.lang.Number getUsedSize() {
            return usedSize;
        }

        /**
         * Allocated JavaScript heap size in bytes.
         */
        public java.lang.Number getTotalSize() {
            return totalSize;
        }

        /**
         * Used size in bytes in the embedder's garbage-collected heap.
         */
        public java.lang.Number getEmbedderHeapUsedSize() {
            return embedderHeapUsedSize;
        }

        /**
         * Size in bytes of backing storage for array buffers and external strings.
         */
        public java.lang.Number getBackingStorageSize() {
            return backingStorageSize;
        }

        private static GetHeapUsageResponse fromJson(JsonInput input) {
            java.lang.Number usedSize = 0;
            java.lang.Number totalSize = 0;
            java.lang.Number embedderHeapUsedSize = 0;
            java.lang.Number backingStorageSize = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "usedSize":
                        usedSize = input.nextNumber();
                        break;
                    case "totalSize":
                        totalSize = input.nextNumber();
                        break;
                    case "embedderHeapUsedSize":
                        embedderHeapUsedSize = input.nextNumber();
                        break;
                    case "backingStorageSize":
                        backingStorageSize = input.nextNumber();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetHeapUsageResponse(usedSize, totalSize, embedderHeapUsedSize, backingStorageSize);
        }
    }

    /**
     * Returns the JavaScript heap usage.
     * It is the total usage of the corresponding isolate not scoped to a particular Runtime.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.GetHeapUsageResponse> getHeapUsage() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.getHeapUsage", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.GetHeapUsageResponse.class));
    }

    public static class GetPropertiesResponse {

        private final java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PropertyDescriptor> result;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.InternalPropertyDescriptor>> internalProperties;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PrivatePropertyDescriptor>> privateProperties;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public GetPropertiesResponse(java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PropertyDescriptor> result, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.InternalPropertyDescriptor>> internalProperties, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PrivatePropertyDescriptor>> privateProperties, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.internalProperties = internalProperties;
            this.privateProperties = privateProperties;
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Object properties.
         */
        public java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PropertyDescriptor> getResult() {
            return result;
        }

        /**
         * Internal object properties (only of the element itself).
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.InternalPropertyDescriptor>> getInternalProperties() {
            return internalProperties;
        }

        /**
         * Object private properties.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PrivatePropertyDescriptor>> getPrivateProperties() {
            return privateProperties;
        }

        /**
         * Exception details.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static GetPropertiesResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PropertyDescriptor> result = null;
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.InternalPropertyDescriptor>> internalProperties = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.runtime.model.PrivatePropertyDescriptor>> privateProperties = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.readArray(org.openqa.selenium.devtools.v143.runtime.model.PropertyDescriptor.class);
                        break;
                    case "internalProperties":
                        internalProperties = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.runtime.model.InternalPropertyDescriptor.class));
                        break;
                    case "privateProperties":
                        privateProperties = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.runtime.model.PrivatePropertyDescriptor.class));
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetPropertiesResponse(result, internalProperties, privateProperties, exceptionDetails);
        }
    }

    /**
     * Returns properties of a given object. Object group of the result is inherited from the target
     * object.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.GetPropertiesResponse> getProperties(org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId objectId, java.util.Optional<java.lang.Boolean> ownProperties, java.util.Optional<java.lang.Boolean> accessorPropertiesOnly, java.util.Optional<java.lang.Boolean> generatePreview, java.util.Optional<java.lang.Boolean> nonIndexedPropertiesOnly) {
        java.util.Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectId", objectId);
        ownProperties.ifPresent(p -> params.put("ownProperties", p));
        accessorPropertiesOnly.ifPresent(p -> params.put("accessorPropertiesOnly", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        nonIndexedPropertiesOnly.ifPresent(p -> params.put("nonIndexedPropertiesOnly", p));
        return new Command<>("Runtime.getProperties", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.GetPropertiesResponse.class));
    }

    /**
     * Returns all let, const and class variables from global scope.
     */
    public static Command<java.util.List<java.lang.String>> globalLexicalScopeNames(java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> executionContextId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command<>("Runtime.globalLexicalScopeNames", Map.copyOf(params), ConverterFunctions.map("names", input -> input.readArray(java.lang.String.class)));
    }

    public static Command<org.openqa.selenium.devtools.v143.runtime.model.RemoteObject> queryObjects(org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId prototypeObjectId, java.util.Optional<java.lang.String> objectGroup) {
        java.util.Objects.requireNonNull(prototypeObjectId, "prototypeObjectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("prototypeObjectId", prototypeObjectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        return new Command<>("Runtime.queryObjects", Map.copyOf(params), ConverterFunctions.map("objects", org.openqa.selenium.devtools.v143.runtime.model.RemoteObject.class));
    }

    /**
     * Releases remote object with given id.
     */
    public static Command<Void> releaseObject(org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId objectId) {
        java.util.Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectId", objectId);
        return new Command<>("Runtime.releaseObject", Map.copyOf(params));
    }

    /**
     * Releases all remote objects that belong to a given group.
     */
    public static Command<Void> releaseObjectGroup(java.lang.String objectGroup) {
        java.util.Objects.requireNonNull(objectGroup, "objectGroup is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectGroup", objectGroup);
        return new Command<>("Runtime.releaseObjectGroup", Map.copyOf(params));
    }

    /**
     * Tells inspected instance to run if it was waiting for debugger to attach.
     */
    public static Command<Void> runIfWaitingForDebugger() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.runIfWaitingForDebugger", Map.copyOf(params));
    }

    public static class RunScriptResponse {

        private final org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails;

        public RunScriptResponse(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        /**
         * Run result.
         */
        public org.openqa.selenium.devtools.v143.runtime.model.RemoteObject getResult() {
            return result;
        }

        /**
         * Exception details.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails() {
            return exceptionDetails;
        }

        private static RunScriptResponse fromJson(JsonInput input) {
            org.openqa.selenium.devtools.v143.runtime.model.RemoteObject result = null;
            java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> exceptionDetails = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.read(org.openqa.selenium.devtools.v143.runtime.model.RemoteObject.class);
                        break;
                    case "exceptionDetails":
                        exceptionDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new RunScriptResponse(result, exceptionDetails);
        }
    }

    /**
     * Runs script with given id in a given context.
     */
    public static Command<org.openqa.selenium.devtools.v143.runtime.Runtime.RunScriptResponse> runScript(org.openqa.selenium.devtools.v143.runtime.model.ScriptId scriptId, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> executionContextId, java.util.Optional<java.lang.String> objectGroup, java.util.Optional<java.lang.Boolean> silent, java.util.Optional<java.lang.Boolean> includeCommandLineAPI, java.util.Optional<java.lang.Boolean> returnByValue, java.util.Optional<java.lang.Boolean> generatePreview, java.util.Optional<java.lang.Boolean> awaitPromise) {
        java.util.Objects.requireNonNull(scriptId, "scriptId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("scriptId", scriptId);
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        silent.ifPresent(p -> params.put("silent", p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", p));
        returnByValue.ifPresent(p -> params.put("returnByValue", p));
        generatePreview.ifPresent(p -> params.put("generatePreview", p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", p));
        return new Command<>("Runtime.runScript", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.runtime.Runtime.RunScriptResponse.class));
    }

    /**
     * Enables or disables async call stacks tracking.
     */
    public static Command<Void> setAsyncCallStackDepth(java.lang.Integer maxDepth) {
        java.util.Objects.requireNonNull(maxDepth, "maxDepth is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("maxDepth", maxDepth);
        return new Command<>("Runtime.setAsyncCallStackDepth", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setCustomObjectFormatterEnabled(java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        return new Command<>("Runtime.setCustomObjectFormatterEnabled", Map.copyOf(params));
    }

    @Beta()
    public static Command<Void> setMaxCallStackSizeToCapture(java.lang.Integer size) {
        java.util.Objects.requireNonNull(size, "size is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("size", size);
        return new Command<>("Runtime.setMaxCallStackSizeToCapture", Map.copyOf(params));
    }

    /**
     * Terminate current or next JavaScript execution.
     * Will cancel the termination when the outer-most script execution ends.
     */
    @Beta()
    public static Command<Void> terminateExecution() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Runtime.terminateExecution", Map.copyOf(params));
    }

    /**
     * If executionContextId is empty, adds binding with the given name on the
     * global objects of all inspected contexts, including those created later,
     * bindings survive reloads.
     * Binding function takes exactly one argument, this argument should be string,
     * in case of any other input, function throws an exception.
     * Each binding function call produces Runtime.bindingCalled notification.
     */
    public static Command<Void> addBinding(java.lang.String name, java.util.Optional<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextId> executionContextId, java.util.Optional<java.lang.String> executionContextName) {
        java.util.Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("name", name);
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        executionContextName.ifPresent(p -> params.put("executionContextName", p));
        return new Command<>("Runtime.addBinding", Map.copyOf(params));
    }

    /**
     * This method does not remove binding function from global object but
     * unsubscribes current runtime agent from Runtime.bindingCalled notifications.
     */
    public static Command<Void> removeBinding(java.lang.String name) {
        java.util.Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("name", name);
        return new Command<>("Runtime.removeBinding", Map.copyOf(params));
    }

    /**
     * This method tries to lookup and populate exception details for a
     * JavaScript Error object.
     * Note that the stackTrace portion of the resulting exceptionDetails will
     * only be populated if the Runtime domain was enabled at the time when the
     * Error was thrown.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails> getExceptionDetails(org.openqa.selenium.devtools.v143.runtime.model.RemoteObjectId errorObjectId) {
        java.util.Objects.requireNonNull(errorObjectId, "errorObjectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("errorObjectId", errorObjectId);
        return new Command<>("Runtime.getExceptionDetails", Map.copyOf(params), ConverterFunctions.map("exceptionDetails", org.openqa.selenium.devtools.v143.runtime.model.ExceptionDetails.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.BindingCalled> bindingCalled() {
        return new Event<>("Runtime.bindingCalled", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.BindingCalled.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.ConsoleAPICalled> consoleAPICalled() {
        return new Event<>("Runtime.consoleAPICalled", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.ConsoleAPICalled.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.ExceptionRevoked> exceptionRevoked() {
        return new Event<>("Runtime.exceptionRevoked", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionRevoked.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.ExceptionThrown> exceptionThrown() {
        return new Event<>("Runtime.exceptionThrown", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.ExceptionThrown.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextDescription> executionContextCreated() {
        return new Event<>("Runtime.executionContextCreated", ConverterFunctions.map("context", org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextDescription.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextDestroyed> executionContextDestroyed() {
        return new Event<>("Runtime.executionContextDestroyed", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.ExecutionContextDestroyed.class));
    }

    public static Event<Void> executionContextsCleared() {
        return new Event<>("Runtime.executionContextsCleared", ConverterFunctions.empty());
    }

    public static Event<org.openqa.selenium.devtools.v143.runtime.model.InspectRequested> inspectRequested() {
        return new Event<>("Runtime.inspectRequested", input -> input.read(org.openqa.selenium.devtools.v143.runtime.model.InspectRequested.class));
    }
}
