package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired upon direct_socket.UDPSocket creation.
 */
@org.openqa.selenium.Beta()
public class DirectUDPSocketCreated {

    private final org.openqa.selenium.devtools.v143.network.model.RequestId identifier;

    private final org.openqa.selenium.devtools.v143.network.model.DirectUDPSocketOptions options;

    private final org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.network.model.Initiator> initiator;

    public DirectUDPSocketCreated(org.openqa.selenium.devtools.v143.network.model.RequestId identifier, org.openqa.selenium.devtools.v143.network.model.DirectUDPSocketOptions options, org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp, java.util.Optional<org.openqa.selenium.devtools.v143.network.model.Initiator> initiator) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.options = java.util.Objects.requireNonNull(options, "options is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    public org.openqa.selenium.devtools.v143.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public org.openqa.selenium.devtools.v143.network.model.DirectUDPSocketOptions getOptions() {
        return options;
    }

    public org.openqa.selenium.devtools.v143.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.network.model.Initiator> getInitiator() {
        return initiator;
    }

    private static DirectUDPSocketCreated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.network.model.RequestId identifier = null;
        org.openqa.selenium.devtools.v143.network.model.DirectUDPSocketOptions options = null;
        org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.network.model.Initiator> initiator = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v143.network.model.RequestId.class);
                    break;
                case "options":
                    options = input.read(org.openqa.selenium.devtools.v143.network.model.DirectUDPSocketOptions.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v143.network.model.MonotonicTime.class);
                    break;
                case "initiator":
                    initiator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.network.model.Initiator.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPSocketCreated(identifier, options, timestamp, initiator);
    }
}
