package org.openqa.selenium.devtools.v143.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum HeavyAdReason {

    NETWORKTOTALLIMIT("NetworkTotalLimit"), CPUTOTALLIMIT("CpuTotalLimit"), CPUPEAKLIMIT("CpuPeakLimit");

    private String value;

    HeavyAdReason(String value) {
        this.value = value;
    }

    public static HeavyAdReason fromString(String s) {
        return java.util.Arrays.stream(HeavyAdReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within HeavyAdReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static HeavyAdReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
