/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v144.network.model.DirectUDPMessage;
import org.openqa.selenium.devtools.v144.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v144.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPSocketChunkReceived {
    private final RequestId identifier;
    private final DirectUDPMessage message;
    private final MonotonicTime timestamp;

    public DirectUDPSocketChunkReceived(RequestId identifier, DirectUDPMessage message, MonotonicTime timestamp) {
        this.identifier = Objects.requireNonNull(identifier, "identifier is required");
        this.message = Objects.requireNonNull(message, "message is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public RequestId getIdentifier() {
        return this.identifier;
    }

    public DirectUDPMessage getMessage() {
        return this.message;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    private static DirectUDPSocketChunkReceived fromJson(JsonInput input) {
        RequestId identifier = null;
        DirectUDPMessage message = null;
        MonotonicTime timestamp = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "identifier": {
                    identifier = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "message": {
                    message = (DirectUDPMessage)input.read(DirectUDPMessage.class);
                    continue block10;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPSocketChunkReceived(identifier, message, timestamp);
    }
}

