/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.exemplar.DoubleExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import java.util.List;

class DoubleFilteredExemplarReservoir
implements DoubleExemplarReservoir {
    private final ExemplarFilterInternal filter;
    private final DoubleExemplarReservoir reservoir;

    DoubleFilteredExemplarReservoir(ExemplarFilterInternal filter, DoubleExemplarReservoir reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<DoubleExemplarData> collectAndResetDoubles(Attributes pointAttributes) {
        return this.reservoir.collectAndResetDoubles(pointAttributes);
    }
}

