/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.RetryRequest;

public class ClientConfig {
    private static final Filter RETRY_FILTER = new RetryRequest();
    private static final Filter DEFAULT_FILTER = new AddSeleniumUserAgent();
    private final URI baseUri;
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Duration wsTimeout;
    private final Filter filters;
    private final Proxy proxy;
    private final Credentials credentials;
    private final SSLContext sslContext;
    private final String version;

    protected ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, Proxy proxy, Credentials credentials, SSLContext sslContext, String version) {
        this(baseUri, connectionTimeout, readTimeout, ClientConfig.defaultWsTimeout(), filters, proxy, credentials, sslContext, version);
    }

    protected ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Duration wsTimeout, Filter filters, Proxy proxy, Credentials credentials, SSLContext sslContext, String version) {
        this.baseUri = baseUri;
        this.connectionTimeout = Require.nonNegative("Connection timeout", connectionTimeout);
        this.readTimeout = Require.nonNegative("Read timeout", readTimeout);
        this.wsTimeout = Require.nonNegative("WebSocket timeout", wsTimeout);
        this.filters = Require.nonNull("Filters", filters);
        this.proxy = proxy;
        this.credentials = credentials;
        this.sslContext = sslContext;
        this.version = version;
    }

    public static ClientConfig defaultConfig() {
        return new ClientConfig(null, ClientConfig.defaultConnectionTimeout(), ClientConfig.defaultReadTimeout(), ClientConfig.defaultWsTimeout(), DEFAULT_FILTER, null, null, null, System.getProperty("webdriver.httpclient.version", null));
    }

    private static Duration defaultWsTimeout() {
        return Duration.ofSeconds(Long.parseLong(System.getProperty("webdriver.httpclient.wsTimeout", "30")));
    }

    private static Duration defaultReadTimeout() {
        return Duration.ofSeconds(Long.parseLong(System.getProperty("webdriver.httpclient.readTimeout", "180")));
    }

    private static Duration defaultConnectionTimeout() {
        return Duration.ofSeconds(Long.parseLong(System.getProperty("webdriver.httpclient.connectionTimeout", "10")));
    }

    public ClientConfig baseUri(URI baseUri) {
        return new ClientConfig(Require.nonNull("Base URI", baseUri), this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public ClientConfig baseUrl(URL baseUrl) {
        try {
            return this.baseUri(Require.nonNull("Base URL", baseUrl).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URL baseUrl() {
        try {
            return this.baseUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientConfig connectionTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, Require.nonNull("Connection timeout", timeout), this.readTimeout, this.wsTimeout, this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig readTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, Require.nonNull("Read timeout", timeout), this.wsTimeout, this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public ClientConfig wsTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, Require.nonNull("WebSocket timeout", timeout), this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public Duration wsTimeout() {
        return this.wsTimeout;
    }

    public ClientConfig withFilter(Filter filter) {
        Require.nonNull("Filter", filter);
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, filter.andThen(DEFAULT_FILTER), this.proxy, this.credentials, this.sslContext, this.version);
    }

    public ClientConfig withRetries() {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters.andThen(RETRY_FILTER), this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Filter filter() {
        return this.filters;
    }

    public ClientConfig proxy(Proxy proxy) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters, Require.nonNull("Proxy", proxy), this.credentials, this.sslContext, this.version);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ClientConfig authenticateAs(Credentials credentials) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters, this.proxy, Require.nonNull("Credentials", credentials), this.sslContext, this.version);
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public ClientConfig sslContext(SSLContext sslContext) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters, this.proxy, this.credentials, Require.nonNull("SSL Context", sslContext), this.version);
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public ClientConfig version(String version) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.wsTimeout, this.filters, this.proxy, this.credentials, this.sslContext, Require.nonNull("Version", version));
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        return "ClientConfig{baseUri=" + String.valueOf(this.baseUri) + ", connectionTimeout=" + String.valueOf(this.connectionTimeout) + ", readTimeout=" + String.valueOf(this.readTimeout) + ", wsTimeout=" + String.valueOf(this.wsTimeout) + ", filters=" + String.valueOf(this.filters) + ", proxy=" + String.valueOf(this.proxy) + ", credentials=" + String.valueOf(this.credentials) + ", sslcontext=" + String.valueOf(this.sslContext) + ", version=" + this.version + "}";
    }
}

