/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.function.Predicate;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;

public class AddHasAuthentication
implements AugmenterProvider<HasAuthentication> {
    private static final Logger LOG = Logger.getLogger(AddHasAuthentication.class.getName());
    private static final Predicate<String> IS_CHROMIUM_BROWSER = name -> Browser.CHROME.is((String)name) || Browser.EDGE.is((String)name) || Browser.OPERA.is((String)name);

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    @Override
    public Class<HasAuthentication> getDescribedInterface() {
        return HasAuthentication.class;
    }

    @Override
    public HasAuthentication getImplementation(Capabilities capabilities, ExecuteMethod executeMethod) {
        return (whenThisMatches, useTheseCredentials) -> {
            Require.nonNull("Check to use to see how we should authenticate", whenThisMatches);
            Require.nonNull("Credentials to use when authenticating", useTheseCredentials);
            if (((RemoteExecuteMethod)executeMethod).getWrappedDriver() instanceof HasDevTools) {
                RemoteWebDriver driver = ((RemoteExecuteMethod)executeMethod).getWrappedDriver();
                DevTools devTools = ((HasDevTools)((Object)driver)).getDevTools();
                devTools.createSessionIfThereIsNotOne();
                devTools.getDomains().network().addAuthHandler(whenThisMatches, useTheseCredentials);
            }
        };
    }
}

