/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.internal.Sets;

public class MapConfig
implements Config {
    private final Map<String, Map<String, Object>> raw;

    public MapConfig() {
        this(Collections.emptyMap());
    }

    public MapConfig(Map<String, Object> raw) {
        Require.nonNull("Underlying map", raw);
        this.raw = raw.entrySet().stream().filter(entry -> entry.getValue() instanceof Map).collect(Collectors.toUnmodifiableMap(entry -> (String)entry.getKey(), entry -> ((Map)entry.getValue()).entrySet().stream().filter(e -> e.getKey() instanceof String).collect(Collectors.toUnmodifiableMap(e -> String.valueOf(e.getKey()), e -> e.getValue()))));
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        Map<String, Object> rawSection = this.raw.get(section);
        if (rawSection == null) {
            return Optional.empty();
        }
        Object value = rawSection.get(option);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.stream().anyMatch(item -> item instanceof Map)) {
                return Optional.of(collection.stream().map(item -> (Map)item).map(this::toEntryList).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList()));
            }
            return Optional.of(collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(Collectors.toUnmodifiableList()));
        }
        if (value instanceof Map) {
            return Optional.of(this.toEntryList((Map)value));
        }
        return Optional.of(List.of(String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return Set.copyOf(this.raw.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        Map values = this.raw.getOrDefault(section, Collections.emptyMap());
        return Sets.sortedSet(values.keySet());
    }
}

