/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.WebDriverInfo;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class EdgeDriverInfo
extends ChromiumDriverInfo {
    private static final Logger LOG = Logger.getLogger(EdgeDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Edge";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.EDGE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.EDGE.is(capabilities.getBrowserName()) || "webview2".equalsIgnoreCase(capabilities.getBrowserName()) || capabilities.getCapability("ms:edgeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new DriverFinder(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return new DriverFinder(EdgeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities, ClientConfig clientConfig) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(new EdgeOptions().merge(capabilities), clientConfig));
    }
}

