/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Locale;

public enum Architecture {
    X86(new String[]{"x86", "i386", "ia32", "i686", "i486", "i86", "pentium", "pentium_pro", "pentium_pro+mmx", "pentium+mmx"}){

        @Override
        public int getDataModel() {
            return 32;
        }
    }
    ,
    X64("amd64", "ia64", "x86_64"),
    ARM("aarch64", "arm"),
    MIPS32(new String[]{"mips32"}){

        @Override
        public int getDataModel() {
            return 32;
        }
    }
    ,
    MIPS64("mips64"),
    ANY(new String[]{""}){

        @Override
        public boolean is(Architecture compareWith) {
            return true;
        }
    };

    private final String[] archIdentifiers;

    private Architecture(String ... partOfArch) {
        this.archIdentifiers = partOfArch;
    }

    public boolean is(Architecture compareWith) {
        return this.equals((Object)compareWith);
    }

    public int getDataModel() {
        return 64;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static Architecture getCurrent() {
        return Architecture.extractFromSysProperty(System.getProperty("os.arch"));
    }

    public static Architecture extractFromSysProperty(String arch) {
        if (arch != null) {
            arch = arch.toLowerCase(Locale.ENGLISH);
        }
        for (Architecture architecture : Architecture.values()) {
            if (architecture == ANY) continue;
            for (String matcher : architecture.archIdentifiers) {
                if (!matcher.equals(arch)) continue;
                return architecture;
            }
        }
        throw new UnsupportedOperationException("Unknown architecture: \"" + arch + "\"");
    }
}

