/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Directives;
import graphql.ExperimentalApi;
import graphql.language.Argument;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.VariableReference;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.List;
import java.util.Optional;

@ExperimentalApi
public class DeferDirectiveOnValidOperation
extends AbstractRule {
    public DeferDirectiveOnValidOperation(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
        this.setVisitFragmentSpreads(true);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        if (!this.isExperimentalApiKeyEnabled("ENABLE_INCREMENTAL_SUPPORT").booleanValue()) {
            return;
        }
        if (!Directives.DeferDirective.getName().equals(directive.getName())) {
            return;
        }
        Optional<OperationDefinition> operationDefinition = this.getOperationDefinition(ancestors);
        if (operationDefinition.isPresent() && OperationDefinition.Operation.SUBSCRIPTION.equals((Object)operationDefinition.get().getOperation()) && !this.ifArgumentMightBeFalse(directive).booleanValue()) {
            String message = this.i18n(ValidationErrorType.MisplacedDirective, "IncrementalDirective.notAllowedSubscriptionOperation", directive.getName());
            this.addError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message);
        }
    }

    private Optional<OperationDefinition> getOperationDefinition(List<Node> ancestors) {
        return ancestors.stream().filter(doc -> doc instanceof OperationDefinition).map(def -> (OperationDefinition)def).findFirst();
    }

    private Boolean ifArgumentMightBeFalse(Directive directive) {
        Argument ifArgument = directive.getArgumentsByName().get("if");
        if (ifArgument == null) {
            return false;
        }
        if (ifArgument.getValue() instanceof BooleanValue) {
            return !((BooleanValue)ifArgument.getValue()).isValue();
        }
        if (ifArgument.getValue() instanceof VariableReference) {
            return true;
        }
        return false;
    }
}

