/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLScalarType;
import graphql.schema.TypeResolver;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public class CombinedWiringFactory
implements WiringFactory {
    private final List<WiringFactory> factories;

    public CombinedWiringFactory(List<WiringFactory> factories) {
        Assert.assertNotNull(factories, () -> "You must provide a list of wiring factories");
        this.factories = new ArrayList<WiringFactory>(factories);
    }

    @Override
    public boolean providesTypeResolver(InterfaceWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeResolver getTypeResolver(InterfaceWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(environment)) continue;
            return factory.getTypeResolver(environment);
        }
        return (TypeResolver)Assert.assertShouldNeverHappen();
    }

    @Override
    public boolean providesTypeResolver(UnionWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeResolver getTypeResolver(UnionWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(environment)) continue;
            return factory.getTypeResolver(environment);
        }
        return (TypeResolver)Assert.assertShouldNeverHappen();
    }

    @Override
    public boolean providesDataFetcherFactory(FieldWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcherFactory(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> DataFetcherFactory<T> getDataFetcherFactory(FieldWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcherFactory(environment)) continue;
            return factory.getDataFetcherFactory(environment);
        }
        return (DataFetcherFactory)Assert.assertShouldNeverHappen();
    }

    @Override
    public boolean providesDataFetcher(FieldWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcher(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataFetcher getDataFetcher(FieldWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcher(environment)) continue;
            return factory.getDataFetcher(environment);
        }
        return (DataFetcher)Assert.assertShouldNeverHappen();
    }

    @Override
    public boolean providesScalar(ScalarWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesScalar(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GraphQLScalarType getScalar(ScalarWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesScalar(environment)) continue;
            return factory.getScalar(environment);
        }
        return (GraphQLScalarType)Assert.assertShouldNeverHappen();
    }

    @Override
    public boolean providesSchemaDirectiveWiring(SchemaDirectiveWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesSchemaDirectiveWiring(environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SchemaDirectiveWiring getSchemaDirectiveWiring(SchemaDirectiveWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesSchemaDirectiveWiring(environment)) continue;
            return factory.getSchemaDirectiveWiring(environment);
        }
        return (SchemaDirectiveWiring)Assert.assertShouldNeverHappen();
    }

    @Override
    public DataFetcher getDefaultDataFetcher(FieldWiringEnvironment environment) {
        for (WiringFactory factory : this.factories) {
            if (factory.getDefaultDataFetcher(environment) == null) continue;
            return factory.getDefaultDataFetcher(environment);
        }
        return null;
    }
}

