package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Bundles the parameters for shared storage access events whose
 * presence/absence can vary according to SharedStorageAccessType.
 */
public class SharedStorageAccessParams {

    private final java.util.Optional<java.lang.String> scriptSourceUrl;

    private final java.util.Optional<java.lang.String> dataOrigin;

    private final java.util.Optional<java.lang.String> operationName;

    private final java.util.Optional<java.lang.String> operationId;

    private final java.util.Optional<java.lang.Boolean> keepAlive;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.SharedStoragePrivateAggregationConfig> privateAggregationConfig;

    private final java.util.Optional<java.lang.String> serializedData;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata;

    private final java.util.Optional<java.lang.String> urnUuid;

    private final java.util.Optional<java.lang.String> key;

    private final java.util.Optional<java.lang.String> value;

    private final java.util.Optional<java.lang.Boolean> ignoreIfPresent;

    private final java.util.Optional<java.lang.Integer> workletOrdinal;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.target.model.TargetID> workletTargetId;

    private final java.util.Optional<java.lang.String> withLock;

    private final java.util.Optional<java.lang.String> batchUpdateId;

    private final java.util.Optional<java.lang.Integer> batchSize;

    public SharedStorageAccessParams(java.util.Optional<java.lang.String> scriptSourceUrl, java.util.Optional<java.lang.String> dataOrigin, java.util.Optional<java.lang.String> operationName, java.util.Optional<java.lang.String> operationId, java.util.Optional<java.lang.Boolean> keepAlive, java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.SharedStoragePrivateAggregationConfig> privateAggregationConfig, java.util.Optional<java.lang.String> serializedData, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata, java.util.Optional<java.lang.String> urnUuid, java.util.Optional<java.lang.String> key, java.util.Optional<java.lang.String> value, java.util.Optional<java.lang.Boolean> ignoreIfPresent, java.util.Optional<java.lang.Integer> workletOrdinal, java.util.Optional<org.openqa.selenium.devtools.v143.target.model.TargetID> workletTargetId, java.util.Optional<java.lang.String> withLock, java.util.Optional<java.lang.String> batchUpdateId, java.util.Optional<java.lang.Integer> batchSize) {
        this.scriptSourceUrl = scriptSourceUrl;
        this.dataOrigin = dataOrigin;
        this.operationName = operationName;
        this.operationId = operationId;
        this.keepAlive = keepAlive;
        this.privateAggregationConfig = privateAggregationConfig;
        this.serializedData = serializedData;
        this.urlsWithMetadata = urlsWithMetadata;
        this.urnUuid = urnUuid;
        this.key = key;
        this.value = value;
        this.ignoreIfPresent = ignoreIfPresent;
        this.workletOrdinal = workletOrdinal;
        this.workletTargetId = workletTargetId;
        this.withLock = withLock;
        this.batchUpdateId = batchUpdateId;
        this.batchSize = batchSize;
    }

    /**
     * Spec of the module script URL.
     * Present only for SharedStorageAccessMethods: addModule and
     * createWorklet.
     */
    public java.util.Optional<java.lang.String> getScriptSourceUrl() {
        return scriptSourceUrl;
    }

    /**
     * String denoting "context-origin", "script-origin", or a custom
     * origin to be used as the worklet's data origin.
     * Present only for SharedStorageAccessMethod: createWorklet.
     */
    public java.util.Optional<java.lang.String> getDataOrigin() {
        return dataOrigin;
    }

    /**
     * Name of the registered operation to be run.
     * Present only for SharedStorageAccessMethods: run and selectURL.
     */
    public java.util.Optional<java.lang.String> getOperationName() {
        return operationName;
    }

    /**
     * ID of the operation call.
     * Present only for SharedStorageAccessMethods: run and selectURL.
     */
    public java.util.Optional<java.lang.String> getOperationId() {
        return operationId;
    }

    /**
     * Whether or not to keep the worket alive for future run or selectURL
     * calls.
     * Present only for SharedStorageAccessMethods: run and selectURL.
     */
    public java.util.Optional<java.lang.Boolean> getKeepAlive() {
        return keepAlive;
    }

    /**
     * Configures the private aggregation options.
     * Present only for SharedStorageAccessMethods: run and selectURL.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.SharedStoragePrivateAggregationConfig> getPrivateAggregationConfig() {
        return privateAggregationConfig;
    }

    /**
     * The operation's serialized data in bytes (converted to a string).
     * Present only for SharedStorageAccessMethods: run and selectURL.
     * TODO(crbug.com/401011862): Consider updating this parameter to binary.
     */
    public java.util.Optional<java.lang.String> getSerializedData() {
        return serializedData;
    }

    /**
     * Array of candidate URLs' specs, along with any associated metadata.
     * Present only for SharedStorageAccessMethod: selectURL.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.storage.model.SharedStorageUrlWithMetadata>> getUrlsWithMetadata() {
        return urlsWithMetadata;
    }

    /**
     * Spec of the URN:UUID generated for a selectURL call.
     * Present only for SharedStorageAccessMethod: selectURL.
     */
    public java.util.Optional<java.lang.String> getUrnUuid() {
        return urnUuid;
    }

    /**
     * Key for a specific entry in an origin's shared storage.
     * Present only for SharedStorageAccessMethods: set, append, delete, and
     * get.
     */
    public java.util.Optional<java.lang.String> getKey() {
        return key;
    }

    /**
     * Value for a specific entry in an origin's shared storage.
     * Present only for SharedStorageAccessMethods: set and append.
     */
    public java.util.Optional<java.lang.String> getValue() {
        return value;
    }

    /**
     * Whether or not to set an entry for a key if that key is already present.
     * Present only for SharedStorageAccessMethod: set.
     */
    public java.util.Optional<java.lang.Boolean> getIgnoreIfPresent() {
        return ignoreIfPresent;
    }

    /**
     * A number denoting the (0-based) order of the worklet's
     * creation relative to all other shared storage worklets created by
     * documents using the current storage partition.
     * Present only for SharedStorageAccessMethods: addModule, createWorklet.
     */
    public java.util.Optional<java.lang.Integer> getWorkletOrdinal() {
        return workletOrdinal;
    }

    /**
     * Hex representation of the DevTools token used as the TargetID for the
     * associated shared storage worklet.
     * Present only for SharedStorageAccessMethods: addModule, createWorklet,
     * run, selectURL, and any other SharedStorageAccessMethod when the
     * SharedStorageAccessScope is sharedStorageWorklet.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.target.model.TargetID> getWorkletTargetId() {
        return workletTargetId;
    }

    /**
     * Name of the lock to be acquired, if present.
     * Optionally present only for SharedStorageAccessMethods: batchUpdate,
     * set, append, delete, and clear.
     */
    public java.util.Optional<java.lang.String> getWithLock() {
        return withLock;
    }

    /**
     * If the method has been called as part of a batchUpdate, then this
     * number identifies the batch to which it belongs.
     * Optionally present only for SharedStorageAccessMethods:
     * batchUpdate (required), set, append, delete, and clear.
     */
    public java.util.Optional<java.lang.String> getBatchUpdateId() {
        return batchUpdateId;
    }

    /**
     * Number of modifier methods sent in batch.
     * Present only for SharedStorageAccessMethod: batchUpdate.
     */
    public java.util.Optional<java.lang.Integer> getBatchSize() {
        return batchSize;
    }

    private static SharedStorageAccessParams fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> scriptSourceUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> dataOrigin = java.util.Optional.empty();
        java.util.Optional<java.lang.String> operationName = java.util.Optional.empty();
        java.util.Optional<java.lang.String> operationId = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> keepAlive = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.SharedStoragePrivateAggregationConfig> privateAggregationConfig = java.util.Optional.empty();
        java.util.Optional<java.lang.String> serializedData = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata = java.util.Optional.empty();
        java.util.Optional<java.lang.String> urnUuid = java.util.Optional.empty();
        java.util.Optional<java.lang.String> key = java.util.Optional.empty();
        java.util.Optional<java.lang.String> value = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> ignoreIfPresent = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> workletOrdinal = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v143.target.model.TargetID> workletTargetId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> withLock = java.util.Optional.empty();
        java.util.Optional<java.lang.String> batchUpdateId = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> batchSize = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptSourceUrl":
                    scriptSourceUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "dataOrigin":
                    dataOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "operationName":
                    operationName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "operationId":
                    operationId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "keepAlive":
                    keepAlive = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "privateAggregationConfig":
                    privateAggregationConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.storage.model.SharedStoragePrivateAggregationConfig.class));
                    break;
                case "serializedData":
                    serializedData = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "urlsWithMetadata":
                    urlsWithMetadata = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.storage.model.SharedStorageUrlWithMetadata.class));
                    break;
                case "urnUuid":
                    urnUuid = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "key":
                    key = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "ignoreIfPresent":
                    ignoreIfPresent = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "workletOrdinal":
                    workletOrdinal = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "workletTargetId":
                    workletTargetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.target.model.TargetID.class));
                    break;
                case "withLock":
                    withLock = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "batchUpdateId":
                    batchUpdateId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "batchSize":
                    batchSize = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageAccessParams(scriptSourceUrl, dataOrigin, operationName, operationId, keepAlive, privateAggregationConfig, serializedData, urlsWithMetadata, urnUuid, key, value, ignoreIfPresent, workletOrdinal, workletTargetId, withLock, batchUpdateId, batchSize);
    }
}
