package org.openqa.selenium.devtools.v143.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for drawing the source order of an elements children.
 */
public class SourceOrderConfig {

    private final org.openqa.selenium.devtools.v143.dom.model.RGBA parentOutlineColor;

    private final org.openqa.selenium.devtools.v143.dom.model.RGBA childOutlineColor;

    public SourceOrderConfig(org.openqa.selenium.devtools.v143.dom.model.RGBA parentOutlineColor, org.openqa.selenium.devtools.v143.dom.model.RGBA childOutlineColor) {
        this.parentOutlineColor = java.util.Objects.requireNonNull(parentOutlineColor, "parentOutlineColor is required");
        this.childOutlineColor = java.util.Objects.requireNonNull(childOutlineColor, "childOutlineColor is required");
    }

    /**
     * the color to outline the given element in.
     */
    public org.openqa.selenium.devtools.v143.dom.model.RGBA getParentOutlineColor() {
        return parentOutlineColor;
    }

    /**
     * the color to outline the child elements in.
     */
    public org.openqa.selenium.devtools.v143.dom.model.RGBA getChildOutlineColor() {
        return childOutlineColor;
    }

    private static SourceOrderConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.dom.model.RGBA parentOutlineColor = null;
        org.openqa.selenium.devtools.v143.dom.model.RGBA childOutlineColor = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "parentOutlineColor":
                    parentOutlineColor = input.read(org.openqa.selenium.devtools.v143.dom.model.RGBA.class);
                    break;
                case "childOutlineColor":
                    childOutlineColor = input.read(org.openqa.selenium.devtools.v143.dom.model.RGBA.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SourceOrderConfig(parentOutlineColor, childOutlineColor);
    }
}
