package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when direct_socket.TCPSocket is aborted.
 */
@org.openqa.selenium.Beta()
public class DirectTCPSocketAborted {

    private final org.openqa.selenium.devtools.v143.network.model.RequestId identifier;

    private final java.lang.String errorMessage;

    private final org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp;

    public DirectTCPSocketAborted(org.openqa.selenium.devtools.v143.network.model.RequestId identifier, java.lang.String errorMessage, org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.errorMessage = java.util.Objects.requireNonNull(errorMessage, "errorMessage is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public org.openqa.selenium.devtools.v143.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public java.lang.String getErrorMessage() {
        return errorMessage;
    }

    public org.openqa.selenium.devtools.v143.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    private static DirectTCPSocketAborted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.network.model.RequestId identifier = null;
        java.lang.String errorMessage = null;
        org.openqa.selenium.devtools.v143.network.model.MonotonicTime timestamp = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v143.network.model.RequestId.class);
                    break;
                case "errorMessage":
                    errorMessage = input.nextString();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v143.network.model.MonotonicTime.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectTCPSocketAborted(identifier, errorMessage, timestamp);
    }
}
