package org.openqa.selenium.devtools.v144.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * List of FinalStatus reasons for Prerender2.
 */
public enum PrerenderFinalStatus {

    ACTIVATED("Activated"),
    DESTROYED("Destroyed"),
    LOWENDDEVICE("LowEndDevice"),
    INVALIDSCHEMEREDIRECT("InvalidSchemeRedirect"),
    INVALIDSCHEMENAVIGATION("InvalidSchemeNavigation"),
    NAVIGATIONREQUESTBLOCKEDBYCSP("NavigationRequestBlockedByCsp"),
    MOJOBINDERPOLICY("MojoBinderPolicy"),
    RENDERERPROCESSCRASHED("RendererProcessCrashed"),
    RENDERERPROCESSKILLED("RendererProcessKilled"),
    DOWNLOAD("Download"),
    TRIGGERDESTROYED("TriggerDestroyed"),
    NAVIGATIONNOTCOMMITTED("NavigationNotCommitted"),
    NAVIGATIONBADHTTPSTATUS("NavigationBadHttpStatus"),
    CLIENTCERTREQUESTED("ClientCertRequested"),
    NAVIGATIONREQUESTNETWORKERROR("NavigationRequestNetworkError"),
    CANCELALLHOSTSFORTESTING("CancelAllHostsForTesting"),
    DIDFAILLOAD("DidFailLoad"),
    STOP("Stop"),
    SSLCERTIFICATEERROR("SslCertificateError"),
    LOGINAUTHREQUESTED("LoginAuthRequested"),
    UACHANGEREQUIRESRELOAD("UaChangeRequiresReload"),
    BLOCKEDBYCLIENT("BlockedByClient"),
    AUDIOOUTPUTDEVICEREQUESTED("AudioOutputDeviceRequested"),
    MIXEDCONTENT("MixedContent"),
    TRIGGERBACKGROUNDED("TriggerBackgrounded"),
    MEMORYLIMITEXCEEDED("MemoryLimitExceeded"),
    DATASAVERENABLED("DataSaverEnabled"),
    TRIGGERURLHASEFFECTIVEURL("TriggerUrlHasEffectiveUrl"),
    ACTIVATEDBEFORESTARTED("ActivatedBeforeStarted"),
    INACTIVEPAGERESTRICTION("InactivePageRestriction"),
    STARTFAILED("StartFailed"),
    TIMEOUTBACKGROUNDED("TimeoutBackgrounded"),
    CROSSSITEREDIRECTININITIALNAVIGATION("CrossSiteRedirectInInitialNavigation"),
    CROSSSITENAVIGATIONININITIALNAVIGATION("CrossSiteNavigationInInitialNavigation"),
    SAMESITECROSSORIGINREDIRECTNOTOPTINININITIALNAVIGATION("SameSiteCrossOriginRedirectNotOptInInInitialNavigation"),
    SAMESITECROSSORIGINNAVIGATIONNOTOPTINININITIALNAVIGATION("SameSiteCrossOriginNavigationNotOptInInInitialNavigation"),
    ACTIVATIONNAVIGATIONPARAMETERMISMATCH("ActivationNavigationParameterMismatch"),
    ACTIVATEDINBACKGROUND("ActivatedInBackground"),
    EMBEDDERHOSTDISALLOWED("EmbedderHostDisallowed"),
    ACTIVATIONNAVIGATIONDESTROYEDBEFORESUCCESS("ActivationNavigationDestroyedBeforeSuccess"),
    TABCLOSEDBYUSERGESTURE("TabClosedByUserGesture"),
    TABCLOSEDWITHOUTUSERGESTURE("TabClosedWithoutUserGesture"),
    PRIMARYMAINFRAMERENDERERPROCESSCRASHED("PrimaryMainFrameRendererProcessCrashed"),
    PRIMARYMAINFRAMERENDERERPROCESSKILLED("PrimaryMainFrameRendererProcessKilled"),
    ACTIVATIONFRAMEPOLICYNOTCOMPATIBLE("ActivationFramePolicyNotCompatible"),
    PRELOADINGDISABLED("PreloadingDisabled"),
    BATTERYSAVERENABLED("BatterySaverEnabled"),
    ACTIVATEDDURINGMAINFRAMENAVIGATION("ActivatedDuringMainFrameNavigation"),
    PRELOADINGUNSUPPORTEDBYWEBCONTENTS("PreloadingUnsupportedByWebContents"),
    CROSSSITEREDIRECTINMAINFRAMENAVIGATION("CrossSiteRedirectInMainFrameNavigation"),
    CROSSSITENAVIGATIONINMAINFRAMENAVIGATION("CrossSiteNavigationInMainFrameNavigation"),
    SAMESITECROSSORIGINREDIRECTNOTOPTININMAINFRAMENAVIGATION("SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation"),
    SAMESITECROSSORIGINNAVIGATIONNOTOPTININMAINFRAMENAVIGATION("SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation"),
    MEMORYPRESSUREONTRIGGER("MemoryPressureOnTrigger"),
    MEMORYPRESSUREAFTERTRIGGERED("MemoryPressureAfterTriggered"),
    PRERENDERINGDISABLEDBYDEVTOOLS("PrerenderingDisabledByDevTools"),
    SPECULATIONRULEREMOVED("SpeculationRuleRemoved"),
    ACTIVATEDWITHAUXILIARYBROWSINGCONTEXTS("ActivatedWithAuxiliaryBrowsingContexts"),
    MAXNUMOFRUNNINGEAGERPRERENDERSEXCEEDED("MaxNumOfRunningEagerPrerendersExceeded"),
    MAXNUMOFRUNNINGNONEAGERPRERENDERSEXCEEDED("MaxNumOfRunningNonEagerPrerendersExceeded"),
    MAXNUMOFRUNNINGEMBEDDERPRERENDERSEXCEEDED("MaxNumOfRunningEmbedderPrerendersExceeded"),
    PRERENDERINGURLHASEFFECTIVEURL("PrerenderingUrlHasEffectiveUrl"),
    REDIRECTEDPRERENDERINGURLHASEFFECTIVEURL("RedirectedPrerenderingUrlHasEffectiveUrl"),
    ACTIVATIONURLHASEFFECTIVEURL("ActivationUrlHasEffectiveUrl"),
    JAVASCRIPTINTERFACEADDED("JavaScriptInterfaceAdded"),
    JAVASCRIPTINTERFACEREMOVED("JavaScriptInterfaceRemoved"),
    ALLPRERENDERINGCANCELED("AllPrerenderingCanceled"),
    WINDOWCLOSED("WindowClosed"),
    SLOWNETWORK("SlowNetwork"),
    OTHERPRERENDEREDPAGEACTIVATED("OtherPrerenderedPageActivated"),
    V8OPTIMIZERDISABLED("V8OptimizerDisabled"),
    PRERENDERFAILEDDURINGPREFETCH("PrerenderFailedDuringPrefetch"),
    BROWSINGDATAREMOVED("BrowsingDataRemoved"),
    PRERENDERHOSTREUSED("PrerenderHostReused");

    private String value;

    PrerenderFinalStatus(String value) {
        this.value = value;
    }

    public static PrerenderFinalStatus fromString(String s) {
        return java.util.Arrays.stream(PrerenderFinalStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PrerenderFinalStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PrerenderFinalStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
