package org.openqa.selenium.devtools.v144.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when direct_socket.TCPSocket connection is opened.
 */
@org.openqa.selenium.Beta()
public class DirectTCPSocketOpened {

    private final org.openqa.selenium.devtools.v144.network.model.RequestId identifier;

    private final java.lang.String remoteAddr;

    private final java.lang.Integer remotePort;

    private final org.openqa.selenium.devtools.v144.network.model.MonotonicTime timestamp;

    private final java.util.Optional<java.lang.String> localAddr;

    private final java.util.Optional<java.lang.Integer> localPort;

    public DirectTCPSocketOpened(org.openqa.selenium.devtools.v144.network.model.RequestId identifier, java.lang.String remoteAddr, java.lang.Integer remotePort, org.openqa.selenium.devtools.v144.network.model.MonotonicTime timestamp, java.util.Optional<java.lang.String> localAddr, java.util.Optional<java.lang.Integer> localPort) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.remoteAddr = java.util.Objects.requireNonNull(remoteAddr, "remoteAddr is required");
        this.remotePort = java.util.Objects.requireNonNull(remotePort, "remotePort is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.localAddr = localAddr;
        this.localPort = localPort;
    }

    public org.openqa.selenium.devtools.v144.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public java.lang.String getRemoteAddr() {
        return remoteAddr;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.lang.Integer getRemotePort() {
        return remotePort;
    }

    public org.openqa.selenium.devtools.v144.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    public java.util.Optional<java.lang.String> getLocalAddr() {
        return localAddr;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Integer> getLocalPort() {
        return localPort;
    }

    private static DirectTCPSocketOpened fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.network.model.RequestId identifier = null;
        java.lang.String remoteAddr = null;
        java.lang.Integer remotePort = 0;
        org.openqa.selenium.devtools.v144.network.model.MonotonicTime timestamp = null;
        java.util.Optional<java.lang.String> localAddr = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> localPort = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v144.network.model.RequestId.class);
                    break;
                case "remoteAddr":
                    remoteAddr = input.nextString();
                    break;
                case "remotePort":
                    remotePort = input.nextNumber().intValue();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v144.network.model.MonotonicTime.class);
                    break;
                case "localAddr":
                    localAddr = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "localPort":
                    localPort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectTCPSocketOpened(identifier, remoteAddr, remotePort, timestamp, localAddr, localPort);
    }
}
