package org.openqa.selenium.devtools.v144.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ConnectTiming {

    private final java.lang.Number requestTime;

    public ConnectTiming(java.lang.Number requestTime) {
        this.requestTime = java.util.Objects.requireNonNull(requestTime, "requestTime is required");
    }

    /**
     * Timing's requestTime is a baseline in seconds, while the other numbers are ticks in
     * milliseconds relatively to this requestTime. Matches ResourceTiming's requestTime for
     * the same request (but not for redirected requests).
     */
    public java.lang.Number getRequestTime() {
        return requestTime;
    }

    private static ConnectTiming fromJson(JsonInput input) {
        java.lang.Number requestTime = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestTime":
                    requestTime = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ConnectTiming(requestTime);
    }
}
