package org.openqa.selenium.devtools.v144.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class DialogShown {

    private final java.lang.String dialogId;

    private final org.openqa.selenium.devtools.v144.fedcm.model.DialogType dialogType;

    private final java.util.List<org.openqa.selenium.devtools.v144.fedcm.model.Account> accounts;

    private final java.lang.String title;

    private final java.util.Optional<java.lang.String> subtitle;

    public DialogShown(java.lang.String dialogId, org.openqa.selenium.devtools.v144.fedcm.model.DialogType dialogType, java.util.List<org.openqa.selenium.devtools.v144.fedcm.model.Account> accounts, java.lang.String title, java.util.Optional<java.lang.String> subtitle) {
        this.dialogId = java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        this.dialogType = java.util.Objects.requireNonNull(dialogType, "dialogType is required");
        this.accounts = java.util.Objects.requireNonNull(accounts, "accounts is required");
        this.title = java.util.Objects.requireNonNull(title, "title is required");
        this.subtitle = subtitle;
    }

    public java.lang.String getDialogId() {
        return dialogId;
    }

    public org.openqa.selenium.devtools.v144.fedcm.model.DialogType getDialogType() {
        return dialogType;
    }

    public java.util.List<org.openqa.selenium.devtools.v144.fedcm.model.Account> getAccounts() {
        return accounts;
    }

    /**
     * These exist primarily so that the caller can verify the
     * RP context was used appropriately.
     */
    public java.lang.String getTitle() {
        return title;
    }

    public java.util.Optional<java.lang.String> getSubtitle() {
        return subtitle;
    }

    private static DialogShown fromJson(JsonInput input) {
        java.lang.String dialogId = null;
        org.openqa.selenium.devtools.v144.fedcm.model.DialogType dialogType = null;
        java.util.List<org.openqa.selenium.devtools.v144.fedcm.model.Account> accounts = null;
        java.lang.String title = null;
        java.util.Optional<java.lang.String> subtitle = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "dialogId":
                    dialogId = input.nextString();
                    break;
                case "dialogType":
                    dialogType = input.read(org.openqa.selenium.devtools.v144.fedcm.model.DialogType.class);
                    break;
                case "accounts":
                    accounts = input.readArray(org.openqa.selenium.devtools.v144.fedcm.model.Account.class);
                    break;
                case "title":
                    title = input.nextString();
                    break;
                case "subtitle":
                    subtitle = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DialogShown(dialogId, dialogType, accounts, title, subtitle);
    }
}
