package org.openqa.selenium.devtools.v144.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to IdentityRequestAccount
 */
public class Account {

    private final java.lang.String accountId;

    private final java.lang.String email;

    private final java.lang.String name;

    private final java.lang.String givenName;

    private final java.lang.String pictureUrl;

    private final java.lang.String idpConfigUrl;

    private final java.lang.String idpLoginUrl;

    private final org.openqa.selenium.devtools.v144.fedcm.model.LoginState loginState;

    private final java.util.Optional<java.lang.String> termsOfServiceUrl;

    private final java.util.Optional<java.lang.String> privacyPolicyUrl;

    public Account(java.lang.String accountId, java.lang.String email, java.lang.String name, java.lang.String givenName, java.lang.String pictureUrl, java.lang.String idpConfigUrl, java.lang.String idpLoginUrl, org.openqa.selenium.devtools.v144.fedcm.model.LoginState loginState, java.util.Optional<java.lang.String> termsOfServiceUrl, java.util.Optional<java.lang.String> privacyPolicyUrl) {
        this.accountId = java.util.Objects.requireNonNull(accountId, "accountId is required");
        this.email = java.util.Objects.requireNonNull(email, "email is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.givenName = java.util.Objects.requireNonNull(givenName, "givenName is required");
        this.pictureUrl = java.util.Objects.requireNonNull(pictureUrl, "pictureUrl is required");
        this.idpConfigUrl = java.util.Objects.requireNonNull(idpConfigUrl, "idpConfigUrl is required");
        this.idpLoginUrl = java.util.Objects.requireNonNull(idpLoginUrl, "idpLoginUrl is required");
        this.loginState = java.util.Objects.requireNonNull(loginState, "loginState is required");
        this.termsOfServiceUrl = termsOfServiceUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
    }

    public java.lang.String getAccountId() {
        return accountId;
    }

    public java.lang.String getEmail() {
        return email;
    }

    public java.lang.String getName() {
        return name;
    }

    public java.lang.String getGivenName() {
        return givenName;
    }

    public java.lang.String getPictureUrl() {
        return pictureUrl;
    }

    public java.lang.String getIdpConfigUrl() {
        return idpConfigUrl;
    }

    public java.lang.String getIdpLoginUrl() {
        return idpLoginUrl;
    }

    public org.openqa.selenium.devtools.v144.fedcm.model.LoginState getLoginState() {
        return loginState;
    }

    /**
     * These two are only set if the loginState is signUp
     */
    public java.util.Optional<java.lang.String> getTermsOfServiceUrl() {
        return termsOfServiceUrl;
    }

    public java.util.Optional<java.lang.String> getPrivacyPolicyUrl() {
        return privacyPolicyUrl;
    }

    private static Account fromJson(JsonInput input) {
        java.lang.String accountId = null;
        java.lang.String email = null;
        java.lang.String name = null;
        java.lang.String givenName = null;
        java.lang.String pictureUrl = null;
        java.lang.String idpConfigUrl = null;
        java.lang.String idpLoginUrl = null;
        org.openqa.selenium.devtools.v144.fedcm.model.LoginState loginState = null;
        java.util.Optional<java.lang.String> termsOfServiceUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> privacyPolicyUrl = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "accountId":
                    accountId = input.nextString();
                    break;
                case "email":
                    email = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "givenName":
                    givenName = input.nextString();
                    break;
                case "pictureUrl":
                    pictureUrl = input.nextString();
                    break;
                case "idpConfigUrl":
                    idpConfigUrl = input.nextString();
                    break;
                case "idpLoginUrl":
                    idpLoginUrl = input.nextString();
                    break;
                case "loginState":
                    loginState = input.read(org.openqa.selenium.devtools.v144.fedcm.model.LoginState.class);
                    break;
                case "termsOfServiceUrl":
                    termsOfServiceUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "privacyPolicyUrl":
                    privacyPolicyUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Account(accountId, email, name, givenName, pictureUrl, idpConfigUrl, idpLoginUrl, loginState, termsOfServiceUrl, privacyPolicyUrl);
    }
}
