package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum PermissionElementIssueType {

    INVALIDTYPE("InvalidType"),
    FENCEDFRAMEDISALLOWED("FencedFrameDisallowed"),
    CSPFRAMEANCESTORSMISSING("CspFrameAncestorsMissing"),
    PERMISSIONSPOLICYBLOCKED("PermissionsPolicyBlocked"),
    PADDINGRIGHTUNSUPPORTED("PaddingRightUnsupported"),
    PADDINGBOTTOMUNSUPPORTED("PaddingBottomUnsupported"),
    INSETBOXSHADOWUNSUPPORTED("InsetBoxShadowUnsupported"),
    REQUESTINPROGRESS("RequestInProgress"),
    UNTRUSTEDEVENT("UntrustedEvent"),
    REGISTRATIONFAILED("RegistrationFailed"),
    TYPENOTSUPPORTED("TypeNotSupported"),
    INVALIDTYPEACTIVATION("InvalidTypeActivation"),
    SECURITYCHECKSFAILED("SecurityChecksFailed"),
    ACTIVATIONDISABLED("ActivationDisabled"),
    GEOLOCATIONDEPRECATED("GeolocationDeprecated"),
    INVALIDDISPLAYSTYLE("InvalidDisplayStyle"),
    NONOPAQUECOLOR("NonOpaqueColor"),
    LOWCONTRAST("LowContrast"),
    FONTSIZETOOSMALL("FontSizeTooSmall"),
    FONTSIZETOOLARGE("FontSizeTooLarge"),
    INVALIDSIZEVALUE("InvalidSizeValue");

    private String value;

    PermissionElementIssueType(String value) {
        this.value = value;
    }

    public static PermissionElementIssueType fromString(String s) {
        return java.util.Arrays.stream(PermissionElementIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PermissionElementIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PermissionElementIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
