/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BatchSpanProcessorBuilder {
    private static final Logger logger = Logger.getLogger(BatchSpanProcessorBuilder.class.getName());
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final SpanExporter spanExporter;
    private boolean exportUnsampledSpans = false;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(5000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private Supplier<MeterProvider> meterProvider = MeterProvider::noop;
    private InternalTelemetryVersion telemetryVersion = InternalTelemetryVersion.LEGACY;

    BatchSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
    }

    public BatchSpanProcessorBuilder setExportUnsampledSpans(boolean exportUnsampledSpans) {
        this.exportUnsampledSpans = exportUnsampledSpans;
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((delay >= 0L ? 1 : 0) != 0, (String)"delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.exporterTimeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchSpanProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        Utils.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (String)"maxQueueSize must be positive.");
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchSpanProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument((maxExportBatchSize > 0 ? 1 : 0) != 0, (String)"maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BatchSpanProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = () -> meterProvider;
        return this;
    }

    public BatchSpanProcessorBuilder setMeterProvider(Supplier<MeterProvider> meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    public BatchSpanProcessorBuilder setInternalTelemetryVersion(InternalTelemetryVersion telemetryVersion) {
        Objects.requireNonNull(telemetryVersion, "telemetryVersion");
        this.telemetryVersion = telemetryVersion;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchSpanProcessor build() {
        if (this.maxExportBatchSize > this.maxQueueSize) {
            logger.log(Level.WARNING, "maxExportBatchSize should not exceed maxQueueSize. Setting maxExportBatchSize to {0} instead of {1}", new Object[]{this.maxQueueSize, this.maxExportBatchSize});
            this.maxExportBatchSize = this.maxQueueSize;
        }
        return new BatchSpanProcessor(this.spanExporter, this.exportUnsampledSpans, this.meterProvider, this.telemetryVersion, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

