/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManager;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class DriverFinder {
    private static final Logger LOG = Logger.getLogger(DriverFinder.class.getName());
    private final DriverService service;
    private final Capabilities options;
    private final SeleniumManager seleniumManager;
    private boolean offline;
    private SeleniumManagerOutput.Result result;

    public DriverFinder(DriverService service, Capabilities options) {
        this(service, options, SeleniumManager.getInstance());
    }

    DriverFinder(DriverService service, Capabilities options, SeleniumManager seleniumManager) {
        this.service = service;
        this.options = options;
        this.seleniumManager = seleniumManager;
    }

    public String getDriverPath() {
        return this.getBinaryPaths().getDriverPath();
    }

    public String getBrowserPath() {
        return this.getBinaryPaths().getBrowserPath();
    }

    public boolean isAvailable() {
        try {
            this.offline = false;
            this.getBinaryPaths();
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    public boolean isPresent() {
        try {
            this.offline = true;
            this.getBinaryPaths();
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, "failed to discover driver path", e);
            return false;
        }
    }

    public boolean hasBrowserPath() {
        String browserPath = this.result.getBrowserPath();
        return browserPath != null && !browserPath.isEmpty();
    }

    private SeleniumManagerOutput.Result getBinaryPaths() {
        if (this.result == null) {
            try {
                String driverName = this.service.getDriverName();
                this.result = new SeleniumManagerOutput.Result(this.service.getExecutable());
                if (this.result.getDriverPath() == null) {
                    this.result = new SeleniumManagerOutput.Result(System.getenv(this.service.getDriverEnvironmentVariable()));
                    if (this.result.getDriverPath() == null) {
                        this.result = new SeleniumManagerOutput.Result(System.getProperty(this.service.getDriverProperty()));
                        if (this.result.getDriverPath() == null) {
                            List<String> arguments = this.toArguments();
                            this.result = this.seleniumManager.getBinaryPaths(arguments);
                            Require.state(this.options.getBrowserName(), Path.of(this.result.getBrowserPath(), new String[0])).isExecutable();
                        } else {
                            LOG.fine(String.format("Skipping Selenium Manager, path to %s found in system property: %s", driverName, this.result.getDriverPath()));
                        }
                    }
                } else {
                    LOG.fine(String.format("Skipping Selenium Manager, path to %s specified in Service class: %s", driverName, this.result.getDriverPath()));
                }
                Require.state(driverName, Path.of(this.result.getDriverPath(), new String[0])).isExecutable();
            }
            catch (RuntimeException e) {
                throw new NoSuchDriverException(String.format("Unable to obtain: %s, error %s", this.service.getDriverName(), e.getMessage()), e);
            }
        }
        return this.result;
    }

    private List<String> toArguments() {
        Proxy proxy;
        String browserBinary;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--browser");
        arguments.add(this.options.getBrowserName());
        if (!this.options.getBrowserVersion().isEmpty()) {
            arguments.add("--browser-version");
            arguments.add(this.options.getBrowserVersion());
        }
        if ((browserBinary = DriverFinder.getBrowserBinary(this.options)) != null && !browserBinary.isEmpty()) {
            arguments.add("--browser-path");
            arguments.add(browserBinary);
        }
        if (this.offline) {
            arguments.add("--offline");
        }
        if ((proxy = Proxy.extractFrom(this.options)) != null && proxy.getProxyType() != Proxy.ProxyType.DIRECT && proxy.getProxyType() != Proxy.ProxyType.AUTODETECT) {
            arguments.add("--proxy");
            if (proxy.getSslProxy() != null) {
                arguments.add(proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                arguments.add(proxy.getHttpProxy());
            } else if (proxy.getProxyAutoconfigUrl() != null) {
                arguments.add(proxy.getProxyAutoconfigUrl());
            }
        }
        return arguments;
    }

    private static String getBrowserBinary(Capabilities options) {
        List<String> vendorOptionsCapabilities = List.of("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get("binary");
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while retrieving the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return null;
    }
}

