/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.log.ConsoleLogEntry;
import org.openqa.selenium.bidi.log.JavascriptLogEntry;
import org.openqa.selenium.bidi.module.LogInspector;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.EvaluateResult;
import org.openqa.selenium.bidi.script.EvaluateResultExceptionValue;
import org.openqa.selenium.bidi.script.EvaluateResultSuccess;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.io.Read;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.DomMutation;
import org.openqa.selenium.remote.Script;

@Beta
class RemoteScript
implements Script {
    private static final Json JSON = new Json();
    private final BiDi biDi;
    private final LogInspector logInspector;
    private final org.openqa.selenium.bidi.module.Script script;
    private final WebDriver driver;

    public RemoteScript(WebDriver driver) {
        this.driver = driver;
        this.biDi = ((HasBiDi)((Object)driver)).getBiDi();
        this.logInspector = new LogInspector(driver);
        this.script = new org.openqa.selenium.bidi.module.Script(driver);
    }

    @Override
    public long addConsoleMessageHandler(Consumer<ConsoleLogEntry> consumer) {
        return this.logInspector.onConsoleEntry(consumer);
    }

    @Override
    public void removeConsoleMessageHandler(long id) {
        this.biDi.removeListener(id);
    }

    @Override
    public long addJavaScriptErrorHandler(Consumer<JavascriptLogEntry> consumer) {
        return this.logInspector.onJavaScriptException(consumer);
    }

    @Override
    public void removeJavaScriptErrorHandler(long id) {
        this.biDi.removeListener(id);
    }

    @Override
    public long addDomMutationHandler(Consumer<DomMutation> consumer) {
        String scriptValue = Read.resourceAsString("/org/openqa/selenium/remote/bidi-mutation-listener.js");
        this.script.addPreloadScript(scriptValue, List.of(new ChannelValue("channel_name")));
        return this.script.onMessage(message -> {
            List<WebElement> elements;
            String value = message.getData().getValue().get().toString();
            Map values = (Map)JSON.toType(value, Json.MAP_TYPE);
            String id = (String)values.get("target");
            RemoteScript remoteScript = this;
            synchronized (remoteScript) {
                elements = this.driver.findElements(By.cssSelector(String.format("*[data-__webdriver_id='%s']", id)));
            }
            if (!elements.isEmpty()) {
                DomMutation event = new DomMutation(elements.get(0), String.valueOf(values.get("name")), String.valueOf(values.get("value")), String.valueOf(values.get("oldValue")));
                consumer.accept(event);
            }
        });
    }

    @Override
    public void removeDomMutationHandler(long id) {
        this.biDi.removeListener(id);
    }

    @Override
    public String pin(String script) {
        return this.script.addPreloadScript(script);
    }

    @Override
    public void unpin(String id) {
        this.script.removePreloadScript(id);
    }

    @Override
    public RemoteValue execute(String script, Object ... args) {
        String browsingContextId = this.driver.getWindowHandle();
        ArrayList arguments = new ArrayList();
        Arrays.stream(args).forEach(arg -> arguments.add(LocalValue.getArgument(arg)));
        EvaluateResult result = this.script.callFunctionInBrowsingContext(browsingContextId, script, true, Optional.of(arguments), Optional.empty(), Optional.empty());
        if (result.getResultType().equals((Object)EvaluateResult.Type.SUCCESS)) {
            return ((EvaluateResultSuccess)result).getResult();
        }
        throw new WebDriverException("Error while executing script: " + ((EvaluateResultExceptionValue)result).getExceptionDetails().getText());
    }
}

