/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;

class MessageOutboundConverter
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(MessageOutboundConverter.class.getName());

    MessageOutboundConverter() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Message)) {
            super.write(ctx, msg, promise);
            return;
        }
        Message seMessage = (Message)msg;
        if (seMessage instanceof CloseMessage) {
            CloseMessage closeMessage = (CloseMessage)seMessage;
            ctx.writeAndFlush(new CloseWebSocketFrame(true, 0, closeMessage.code(), closeMessage.reason()));
        } else if (seMessage instanceof BinaryMessage) {
            ctx.writeAndFlush(new BinaryWebSocketFrame(true, 0, Unpooled.copiedBuffer(((BinaryMessage)seMessage).data())));
        } else if (seMessage instanceof TextMessage) {
            ctx.writeAndFlush(new TextWebSocketFrame(true, 0, ((TextMessage)seMessage).text()));
        } else {
            LOG.warning(String.format("Unable to handle %s", msg));
            super.write(ctx, msg, promise);
        }
    }
}

