/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.preparsed.persisted;

import graphql.ExecutionInput;
import graphql.PublicApi;
import graphql.execution.preparsed.persisted.PersistedQueryCache;
import graphql.execution.preparsed.persisted.PersistedQuerySupport;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;

@PublicApi
public class ApolloPersistedQuerySupport
extends PersistedQuerySupport {
    private static final String CHECKSUM_TYPE = "SHA-256";

    public ApolloPersistedQuerySupport(PersistedQueryCache persistedQueryCache) {
        super(persistedQueryCache);
    }

    @Override
    protected Optional<Object> getPersistedQueryId(ExecutionInput executionInput) {
        Map<String, Object> extensions = executionInput.getExtensions();
        Map persistedQuery = (Map)extensions.get("persistedQuery");
        if (persistedQuery != null) {
            Object sha256Hash = persistedQuery.get("sha256Hash");
            return Optional.ofNullable(sha256Hash);
        }
        return Optional.empty();
    }

    @Override
    protected boolean persistedQueryIdIsInvalid(Object persistedQueryId, String queryText) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(CHECKSUM_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest(queryText.getBytes(StandardCharsets.UTF_8)));
        String calculatedChecksum = String.format("%064x", bigInteger);
        return !calculatedChecksum.equalsIgnoreCase(persistedQueryId.toString());
    }
}

