/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class Async {
    public static <T> CombinedBuilder<T> ofExpectedSize(int expectedSize) {
        if (expectedSize == 0) {
            return new Empty();
        }
        if (expectedSize == 1) {
            return new Single();
        }
        return new Many(expectedSize);
    }

    public static <T, U> CompletableFuture<List<U>> each(Collection<T> list, Function<T, Object> cfOrMaterialisedValueFactory) {
        Object l = Async.eachPolymorphic(list, cfOrMaterialisedValueFactory);
        if (l instanceof CompletableFuture) {
            return (CompletableFuture)l;
        }
        return CompletableFuture.completedFuture((List)l);
    }

    public static <T> Object eachPolymorphic(Collection<T> list, Function<T, Object> cfOrMaterialisedValueFactory) {
        CombinedBuilder futures = Async.ofExpectedSize(list.size());
        for (T t2 : list) {
            try {
                Object value = cfOrMaterialisedValueFactory.apply(t2);
                futures.addObject(value);
            }
            catch (Exception e) {
                CompletableFuture cf = new CompletableFuture();
                cf.completeExceptionally(new CompletionException(e));
                futures.add(cf);
            }
        }
        return futures.awaitPolymorphic();
    }

    public static <T, U> CompletableFuture<List<U>> eachSequentially(Iterable<T> list, BiFunction<T, List<U>, Object> cfOrMaterialisedValueFactory) {
        CompletableFuture<List<U>> result = new CompletableFuture<List<U>>();
        Async.eachSequentiallyPolymorphicImpl(list.iterator(), cfOrMaterialisedValueFactory, new ArrayList(), result);
        return result;
    }

    private static <T, U> void eachSequentiallyPolymorphicImpl(Iterator<T> iterator, BiFunction<T, List<U>, Object> cfOrMaterialisedValueFactory, List<U> tmpResult, CompletableFuture<List<U>> overallResult) {
        Object value;
        if (!iterator.hasNext()) {
            overallResult.complete(tmpResult);
            return;
        }
        try {
            value = cfOrMaterialisedValueFactory.apply(iterator.next(), tmpResult);
        }
        catch (Exception e) {
            overallResult.completeExceptionally(new CompletionException(e));
            return;
        }
        if (value instanceof CompletableFuture) {
            CompletableFuture cf = (CompletableFuture)value;
            cf.whenComplete((cfResult, exception) -> {
                if (exception != null) {
                    overallResult.completeExceptionally((Throwable)exception);
                    return;
                }
                tmpResult.add(cfResult);
                Async.eachSequentiallyPolymorphicImpl(iterator, cfOrMaterialisedValueFactory, tmpResult, overallResult);
            });
        } else {
            tmpResult.add(value);
            Async.eachSequentiallyPolymorphicImpl(iterator, cfOrMaterialisedValueFactory, tmpResult, overallResult);
        }
    }

    public static <T> CompletableFuture<T> toCompletableFuture(Object t2) {
        if (t2 instanceof CompletionStage) {
            return ((CompletionStage)t2).toCompletableFuture();
        }
        return CompletableFuture.completedFuture(t2);
    }

    public static Object toCompletableFutureOrMaterializedObject(Object object) {
        if (object instanceof CompletionStage) {
            return ((CompletionStage)object).toCompletableFuture();
        }
        return object;
    }

    public static <T> CompletableFuture<T> tryCatch(Supplier<CompletableFuture<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            CompletableFuture result = new CompletableFuture();
            result.completeExceptionally(e);
            return result;
        }
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable exception) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    public static <T> @NonNull CompletableFuture<T> orNullCompletedFuture(@Nullable CompletableFuture<T> completableFuture) {
        return completableFuture != null ? completableFuture : CompletableFuture.completedFuture(null);
    }

    private static class Many<T>
    implements CombinedBuilder<T> {
        private final Object[] array;
        private int ix;
        private int cfCount;

        private Many(int size) {
            this.array = new Object[size];
            this.ix = 0;
            this.cfCount = 0;
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.array[this.ix++] = completableFuture;
            ++this.cfCount;
        }

        @Override
        public void addObject(Object object) {
            this.array[this.ix++] = object;
            if (object instanceof CompletableFuture) {
                ++this.cfCount;
            }
        }

        @Override
        public CompletableFuture<List<T>> await() {
            this.commonSizeAssert();
            CompletableFuture<List<List<T>>> overallResult = new CompletableFuture<List<List<T>>>();
            if (this.cfCount == 0) {
                overallResult.complete(this.materialisedList(this.array));
            } else {
                CompletableFuture[] cfsArr = this.copyOnlyCFsToArray();
                CompletableFuture.allOf(cfsArr).whenComplete((ignored, exception) -> {
                    if (exception != null) {
                        overallResult.completeExceptionally((Throwable)exception);
                        return;
                    }
                    ArrayList<Object> results = new ArrayList<Object>(this.array.length);
                    if (cfsArr.length == this.array.length) {
                        for (CompletableFuture cf : cfsArr) {
                            results.add(cf.join());
                        }
                    } else {
                        for (Object object : this.array) {
                            if (object instanceof CompletableFuture) {
                                CompletableFuture cf = (CompletableFuture)object;
                                results.add(cf.join());
                                continue;
                            }
                            results.add(object);
                        }
                    }
                    overallResult.complete(results);
                });
            }
            return overallResult;
        }

        private @NonNull CompletableFuture<T>[] copyOnlyCFsToArray() {
            if (this.cfCount == this.array.length) {
                return (CompletableFuture[])Arrays.copyOf(this.array, this.array.length, CompletableFuture[].class);
            }
            int i = 0;
            CompletableFuture[] dest = new CompletableFuture[this.cfCount];
            for (Object o : this.array) {
                if (!(o instanceof CompletableFuture)) continue;
                dest[i] = (CompletableFuture)o;
                ++i;
            }
            return dest;
        }

        @Override
        public Object awaitPolymorphic() {
            if (this.cfCount == 0) {
                this.commonSizeAssert();
                return this.materialisedList(this.array);
            }
            return this.await();
        }

        private @NonNull List<T> materialisedList(Object[] array) {
            ArrayList<Object> results = new ArrayList<Object>(array.length);
            for (Object object : array) {
                results.add(object);
            }
            return results;
        }

        private void commonSizeAssert() {
            Assert.assertTrue(this.ix == this.array.length, () -> "expected size was " + this.array.length + " got " + this.ix);
        }
    }

    private static class Single<T>
    implements CombinedBuilder<T> {
        private Object value;
        private int ix;

        private Single() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.value = completableFuture;
            ++this.ix;
        }

        @Override
        public void addObject(Object object) {
            this.value = object;
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            this.commonSizeAssert();
            if (this.value instanceof CompletableFuture) {
                CompletableFuture cf = (CompletableFuture)this.value;
                return cf.thenApply(Collections::singletonList);
            }
            return CompletableFuture.completedFuture(Collections.singletonList(this.value));
        }

        @Override
        public Object awaitPolymorphic() {
            this.commonSizeAssert();
            if (this.value instanceof CompletableFuture) {
                CompletableFuture cf = (CompletableFuture)this.value;
                return cf.thenApply(Collections::singletonList);
            }
            return Collections.singletonList(this.value);
        }

        private void commonSizeAssert() {
            Assert.assertTrue(this.ix == 1, () -> "expected size was 1 got " + this.ix);
        }
    }

    private static class Empty<T>
    implements CombinedBuilder<T> {
        private int ix;
        private static final CompletableFuture<List<?>> EMPTY = CompletableFuture.completedFuture(Collections.emptyList());

        private Empty() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            ++this.ix;
        }

        @Override
        public void addObject(Object object) {
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == 0, "expected size was 0 got %d", this.ix);
            return Empty.typedEmpty();
        }

        @Override
        public Object awaitPolymorphic() {
            Assert.assertTrue(this.ix == 0, () -> "expected size was 0 got " + this.ix);
            return Collections.emptyList();
        }

        private static <T> CompletableFuture<T> typedEmpty() {
            return EMPTY;
        }
    }

    public static interface CombinedBuilder<T> {
        public void add(CompletableFuture<T> var1);

        public void addObject(Object var1);

        public CompletableFuture<List<T>> await();

        public Object awaitPolymorphic();
    }
}

