/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvPoint2D32f;
import org.bytedeco.opencv.opencv_core.CvPoint2D64f;
import org.bytedeco.opencv.opencv_core.CvPoint3D32f;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractCvPoint3D32f
extends FloatPointer {
    public AbstractCvPoint3D32f(Pointer p) {
        super(p);
    }

    public abstract float x();

    public abstract CvPoint3D32f x(float var1);

    public abstract float y();

    public abstract CvPoint3D32f y(float var1);

    public abstract float z();

    public abstract CvPoint3D32f z(float var1);

    public CvPoint3D32f get(double[] pts) {
        return this.get(pts, 0, pts.length);
    }

    public CvPoint3D32f get(double[] pts, int offset, int length) {
        for (int i = 0; i < length / 3; ++i) {
            this.position(i);
            pts[offset + i * 3] = this.x();
            pts[offset + i * 3 + 1] = this.y();
            pts[offset + i * 3 + 2] = this.z();
        }
        return (CvPoint3D32f)this.position(0L);
    }

    public final CvPoint3D32f put(double[] pts, int offset, int length) {
        for (int i = 0; i < length / 3; ++i) {
            this.position(i);
            this.put(pts[offset + i * 3], pts[offset + i * 3 + 1], pts[offset + i * 3 + 2]);
        }
        return (CvPoint3D32f)this.position(0L);
    }

    public final CvPoint3D32f put(double ... pts) {
        return this.put(pts, 0, pts.length);
    }

    public CvPoint3D32f put(double x, double y, double z) {
        return this.x((float)x).y((float)y).z((float)z);
    }

    public CvPoint3D32f put(CvPoint o) {
        return this.x(o.x()).y(o.y()).z(0.0f);
    }

    public CvPoint3D32f put(CvPoint2D32f o) {
        return this.x(o.x()).y(o.y()).z(0.0f);
    }

    public CvPoint3D32f put(CvPoint2D64f o) {
        return this.x((float)o.x()).y((float)o.y()).z(0.0f);
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + this.x() + ", " + this.y() + ", " + this.z() + ")";
        }
        String s = "";
        long p = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            s = s + (i == 0L ? "(" : " (") + this.x() + ", " + this.y() + ", " + this.z() + ")";
        }
        this.position(p);
        return s;
    }

    static {
        Loader.load();
    }
}

