/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvPoint2D32f;
import org.bytedeco.opencv.opencv_core.CvPoint2D64f;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractCvPoint2D64f
extends DoublePointer {
    public AbstractCvPoint2D64f(Pointer p) {
        super(p);
    }

    public abstract double x();

    public abstract CvPoint2D64f x(double var1);

    public abstract double y();

    public abstract CvPoint2D64f y(double var1);

    @Override
    public CvPoint2D64f get(double[] pts) {
        return this.get(pts, 0, pts.length);
    }

    @Override
    public CvPoint2D64f get(double[] pts, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            this.position(i);
            pts[offset + i * 2] = this.x();
            pts[offset + i * 2 + 1] = this.y();
        }
        return (CvPoint2D64f)this.position(0L);
    }

    @Override
    public final CvPoint2D64f put(double[] pts, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            this.position(i);
            this.put(pts[offset + i * 2], pts[offset + i * 2 + 1]);
        }
        return (CvPoint2D64f)this.position(0L);
    }

    @Override
    public final CvPoint2D64f put(double ... pts) {
        return this.put(pts, 0, pts.length);
    }

    public CvPoint2D64f put(double x, double y) {
        return this.x(x).y(y);
    }

    public CvPoint2D64f put(CvPoint o) {
        return this.x(o.x()).y(o.y());
    }

    public CvPoint2D64f put(CvPoint2D32f o) {
        return this.x(o.x()).y(o.y());
    }

    public CvPoint2D64f put(CvPoint2D64f o) {
        return this.x(o.x()).y(o.y());
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + (float)this.x() + ", " + (float)this.y() + ")";
        }
        String s = "";
        long p = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            s = s + (i == 0L ? "(" : " (") + (float)this.x() + ", " + (float)this.y() + ")";
        }
        this.position(p);
        return s;
    }

    static {
        Loader.load();
    }
}

