package org.openqa.selenium.devtools.v141.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates the various types of GATT event.
 */
public enum GATTOperationType {

    CONNECTION("connection"), DISCOVERY("discovery");

    private String value;

    GATTOperationType(String value) {
        this.value = value;
    }

    public static GATTOperationType fromString(String s) {
        return java.util.Arrays.stream(GATTOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within GATTOperationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static GATTOperationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
