/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ClosedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClosedReaderTest {
    ClosedReaderTest() {
    }

    private void assertEof(Reader reader) throws IOException {
        Assertions.assertEquals((int)-1, (int)reader.read(), (String)"read()");
    }

    @Test
    void testRead() throws IOException {
        try (ClosedReader reader = new ClosedReader();){
            this.assertEof((Reader)reader);
        }
    }

    @Test
    void testReadArray() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(new char[4096]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[0]));
        }
    }

    @Test
    void testReadArrayIndex() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[4096])));
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[1])));
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[0])));
        }
    }

    @Test
    void testReadCharBuffer() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(new char[4096]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[0]));
        }
    }

    @Test
    void testSingleton() throws Exception {
        try (ClosedReader reader = ClosedReader.CLOSED_READER;){
            this.assertEof((Reader)reader);
        }
        reader = ClosedReader.INSTANCE;
        try {
            this.assertEof((Reader)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void testSkip() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((long)0L, (long)reader.skip(4096L));
            Assertions.assertEquals((long)0L, (long)reader.skip(1L));
            Assertions.assertEquals((long)0L, (long)reader.skip(0L));
        }
    }
}

