/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.idealized;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.ScriptId;
import org.openqa.selenium.devtools.idealized.target.model.SessionID;
import org.openqa.selenium.internal.Require;

public abstract class Javascript<SCRIPTID, BINDINGCALLED> {
    private final DevTools devtools;
    private final Map<SessionID, Map<String, ScriptId>> pinnedScripts = new HashMap<SessionID, Map<String, ScriptId>>();
    private final Set<String> bindings = new HashSet<String>();

    public Javascript(DevTools devtools) {
        this.devtools = (DevTools)Require.nonNull((String)"DevTools", (Object)devtools);
    }

    public void disable() {
        this.devtools.send(this.disableRuntime());
        this.devtools.send(this.disablePage());
        this.pinnedScripts.forEach((sessionID, scriptIdMap) -> scriptIdMap.values().forEach(id -> this.removeScriptToEvaluateOnNewDocument(id.getActualId())));
        this.pinnedScripts.clear();
    }

    protected abstract Command<Void> disablePage();

    protected abstract Command<Void> disableRuntime();

    public ScriptId pin(String exposeScriptAs, String script) {
        Map<String, ScriptId> scripts;
        Require.nonNull((String)"Script name", (Object)exposeScriptAs);
        Require.nonNull((String)"Script", (Object)script);
        if (this.pinnedScripts.containsKey(this.devtools.getCdpSession()) && (scripts = this.pinnedScripts.get(this.devtools.getCdpSession())).containsKey(script)) {
            return scripts.get(script);
        }
        this.devtools.send(this.enableRuntime());
        this.devtools.send(this.doAddJsBinding(exposeScriptAs));
        this.devtools.send(this.enablePage());
        SCRIPTID id = this.devtools.send(this.addScriptToEvaluateOnNewDocument(script));
        ScriptId scriptId = new ScriptId(id);
        Map scripts2 = this.pinnedScripts.getOrDefault(this.devtools.getCdpSession(), new HashMap());
        scripts2.put(script, scriptId);
        this.pinnedScripts.put(this.devtools.getCdpSession(), scripts2);
        return scriptId;
    }

    public void addBindingCalledListener(Consumer<String> listener) {
        Require.nonNull((String)"Listener", listener);
        this.devtools.send(this.enableRuntime());
        this.devtools.addListener(this.bindingCalledEvent(), event -> {
            String payload = this.extractPayload(event);
            listener.accept(payload);
        });
    }

    public void addJsBinding(String scriptName) {
        Require.nonNull((String)"Script name", (Object)scriptName);
        this.bindings.add(scriptName);
        this.doAddJsBinding(scriptName);
    }

    public void removeJsBinding(String scriptName) {
        Require.nonNull((String)"Script name", (Object)scriptName);
        this.bindings.remove(scriptName);
        this.doRemoveJsBinding(scriptName);
    }

    protected abstract Command<Void> enableRuntime();

    protected abstract Command<Void> doAddJsBinding(String var1);

    protected abstract Command<Void> doRemoveJsBinding(String var1);

    protected abstract Command<Void> enablePage();

    protected abstract Command<SCRIPTID> addScriptToEvaluateOnNewDocument(String var1);

    protected abstract Command<Void> removeScriptToEvaluateOnNewDocument(SCRIPTID var1);

    protected abstract Event<BINDINGCALLED> bindingCalledEvent();

    protected abstract String extractPayload(BINDINGCALLED var1);
}

