/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;

@Internal
public final class EscapeUtil {
    private EscapeUtil() {
    }

    public static String escapeJsonString(String stringValue) {
        StringBuilder sb = new StringBuilder(stringValue.length());
        EscapeUtil.escapeJsonStringTo(sb, stringValue);
        return sb.toString();
    }

    public static void escapeJsonStringTo(StringBuilder output, String stringValue) {
        int len = stringValue.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = stringValue.charAt(i);
            switch (ch) {
                case '\"': {
                    output.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    output.append("\\b");
                    continue block9;
                }
                case '\f': {
                    output.append("\\f");
                    continue block9;
                }
                case '\n': {
                    output.append("\\n");
                    continue block9;
                }
                case '\r': {
                    output.append("\\r");
                    continue block9;
                }
                case '\t': {
                    output.append("\\t");
                    continue block9;
                }
                default: {
                    output.append(ch);
                }
            }
        }
    }
}

