package org.openqa.selenium.devtools.v137.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingAggregatableValueDictEntry {

    private final java.lang.String key;

    private final java.lang.Number value;

    private final org.openqa.selenium.devtools.v137.storage.model.UnsignedInt64AsBase10 filteringId;

    public AttributionReportingAggregatableValueDictEntry(java.lang.String key, java.lang.Number value, org.openqa.selenium.devtools.v137.storage.model.UnsignedInt64AsBase10 filteringId) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.filteringId = java.util.Objects.requireNonNull(filteringId, "filteringId is required");
    }

    public java.lang.String getKey() {
        return key;
    }

    /**
     * number instead of integer because not all uint32 can be represented by
     * int
     */
    public java.lang.Number getValue() {
        return value;
    }

    public org.openqa.selenium.devtools.v137.storage.model.UnsignedInt64AsBase10 getFilteringId() {
        return filteringId;
    }

    private static AttributionReportingAggregatableValueDictEntry fromJson(JsonInput input) {
        java.lang.String key = null;
        java.lang.Number value = 0;
        org.openqa.selenium.devtools.v137.storage.model.UnsignedInt64AsBase10 filteringId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.nextString();
                    break;
                case "value":
                    value = input.nextNumber();
                    break;
                case "filteringId":
                    filteringId = input.read(org.openqa.selenium.devtools.v137.storage.model.UnsignedInt64AsBase10.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingAggregatableValueDictEntry(key, value, filteringId);
    }
}
