package org.openqa.selenium.devtools.v137.filesystem.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class File {

    private final java.lang.String name;

    private final org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch lastModified;

    private final java.lang.Number size;

    private final java.lang.String type;

    public File(java.lang.String name, org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch lastModified, java.lang.Number size, java.lang.String type) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.lastModified = java.util.Objects.requireNonNull(lastModified, "lastModified is required");
        this.size = java.util.Objects.requireNonNull(size, "size is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    public java.lang.String getName() {
        return name;
    }

    /**
     * Timestamp
     */
    public org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch getLastModified() {
        return lastModified;
    }

    /**
     * Size in bytes
     */
    public java.lang.Number getSize() {
        return size;
    }

    public java.lang.String getType() {
        return type;
    }

    private static File fromJson(JsonInput input) {
        java.lang.String name = null;
        org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch lastModified = null;
        java.lang.Number size = 0;
        java.lang.String type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "lastModified":
                    lastModified = input.read(org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch.class);
                    break;
                case "size":
                    size = input.nextNumber();
                    break;
                case "type":
                    type = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new File(name, lastModified, size, type);
    }
}
