/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractIOFileFilterTest {
    public static void assertFalseFiltersInvoked(int testNumber, TesterFalseFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            Assertions.assertEquals((Object)invoked[i - 1], (Object)filters[i].isInvoked(), (String)("test " + testNumber + " filter " + i + " invoked"));
        }
    }

    public static void assertFileFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        Assertions.assertEquals((Object)expected, (Object)filter.matches(file.toPath()), (String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
    }

    public static void assertFilenameFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()), (String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
    }

    public static void assertFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        Assertions.assertEquals((Object)expected, (Object)((Object)filter.accept(file.toPath(), null)), (String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        if (file.getParentFile() != null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()), (String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
            Assertions.assertEquals((Object)expected, (Object)filter.matches(file.toPath()), (String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        }
    }

    public static void assertTrueFiltersInvoked(int testNumber, TesterTrueFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            Assertions.assertEquals((Object)invoked[i - 1], (Object)filters[i].isInvoked(), (String)("test " + testNumber + " filter " + i + " invoked"));
        }
    }

    public static File determineWorkingDirectoryPath(String key, String defaultPath) {
        String workingPathName = System.getProperty(key, defaultPath);
        return new File(workingPathName);
    }

    public static void resetFalseFilters(TesterFalseFileFilter[] filters) {
        Stream.of(filters).filter(Objects::nonNull).forEach(TesterFalseFileFilter::reset);
    }

    public static void resetTrueFilters(TesterTrueFileFilter[] filters) {
        Stream.of(filters).filter(Objects::nonNull).forEach(TesterTrueFileFilter::reset);
    }

    final class TesterFalseFileFilter
    extends FalseFileFilter {
        private static final long serialVersionUID = -3603047664010401872L;
        private boolean invoked;

        TesterFalseFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }
    }

    final class TesterTrueFileFilter
    extends TrueFileFilter {
        private static final long serialVersionUID = 1828930358172422914L;
        private boolean invoked;

        TesterTrueFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }
    }
}

