/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.HealthCheckFailedException;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeAddedEvent;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeRestartedEvent;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.distributor.GridModel;
import org.openqa.selenium.grid.distributor.NodeRegistry;
import org.openqa.selenium.grid.distributor.local.LocalGridModel;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public class LocalNodeRegistry
implements NodeRegistry {
    private static final Logger LOG = Logger.getLogger(LocalNodeRegistry.class.getName());
    private static final SessionId RESERVED = new SessionId("reserved");
    private final Tracer tracer;
    private final EventBus bus;
    private final HttpClient.Factory clientFactory;
    private final Secret registrationSecret;
    private final Duration healthcheckInterval;
    private final GridModel model;
    private final Map<NodeId, Node> nodes;
    private final Map<NodeId, Runnable> allChecks = new ConcurrentHashMap<NodeId, Runnable>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ScheduledExecutorService nodeHealthCheckService;
    private final ExecutorService nodeHealthCheckExecutor;
    private final Duration purgeNodesInterval;
    private final ScheduledExecutorService purgeDeadNodesService;
    private final int newSessionThreadPoolSize;

    public LocalNodeRegistry(Tracer tracer, EventBus bus, int newSessionThreadPoolSize, HttpClient.Factory clientFactory, Secret registrationSecret, Duration healthcheckInterval, ScheduledExecutorService nodeHealthCheckService, Duration purgeNodesInterval, ScheduledExecutorService purgeDeadNodesService) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.bus = Require.nonNull("Event bus", bus);
        this.clientFactory = Require.nonNull("HTTP client factory", clientFactory);
        this.registrationSecret = Require.nonNull("Registration secret", registrationSecret);
        this.healthcheckInterval = Require.nonNull("Health check interval", healthcheckInterval);
        this.nodeHealthCheckService = Require.nonNull("Node health check service", nodeHealthCheckService);
        this.purgeNodesInterval = Require.nonNull("Purge nodes interval", purgeNodesInterval);
        this.purgeDeadNodesService = Require.nonNull("Purge dead nodes service", purgeDeadNodesService);
        this.newSessionThreadPoolSize = newSessionThreadPoolSize;
        this.model = new LocalGridModel(bus);
        this.nodes = new ConcurrentHashMap<NodeId, Node>();
        this.bus.addListener(NodeStatusEvent.listener(this::register));
        this.bus.addListener(NodeStatusEvent.listener(this.model::refresh));
        this.bus.addListener(NodeRestartedEvent.listener(previousNodeStatus -> this.remove(previousNodeStatus.getNodeId())));
        this.bus.addListener(NodeRemovedEvent.listener(nodeStatus -> this.remove(nodeStatus.getNodeId())));
        this.bus.addListener(NodeDrainComplete.listener(this::remove));
        this.bus.addListener(NodeHeartBeatEvent.listener(nodeStatus -> {
            if (this.nodes.containsKey(nodeStatus.getNodeId())) {
                this.model.touch((NodeStatus)nodeStatus);
            } else {
                this.register((NodeStatus)nodeStatus);
            }
        }));
        this.nodeHealthCheckService.scheduleAtFixedRate(GuardedRunnable.guard(this::runHealthChecks), healthcheckInterval.toMillis(), healthcheckInterval.toMillis(), TimeUnit.MILLISECONDS);
        this.nodeHealthCheckExecutor = Executors.newFixedThreadPool(this.newSessionThreadPoolSize, r -> {
            Thread t2 = new Thread(r);
            t2.setName("node-health-check-" + t2.getId());
            t2.setDaemon(true);
            return t2;
        });
        if (!this.purgeNodesInterval.isZero()) {
            this.purgeDeadNodesService.scheduleAtFixedRate(GuardedRunnable.guard(this.model::purgeDeadNodes), this.purgeNodesInterval.getSeconds(), this.purgeNodesInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(NodeStatus status) {
        Require.nonNull("Node", status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.nodes.containsKey(status.getNodeId())) {
                return;
            }
            if (status.getAvailability() != Availability.UP) {
                return;
            }
            RemoteNode remoteNode = new RemoteNode(this.tracer, this.clientFactory, status.getNodeId(), status.getExternalUri(), this.registrationSecret, status.getSessionTimeout(), status.getSlots().stream().map(slot -> slot.getStereotype()).collect(Collectors.toSet()));
            this.add(remoteNode);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Node node) {
        NodeStatus initialNodeStatus;
        Require.nonNull("Node", node);
        try {
            initialNodeStatus = node.getStatus();
            if (initialNodeStatus.getAvailability() != Availability.UP) {
                return;
            }
            Runnable healthCheck = this.asRunnableHealthCheck(node);
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.nodes.put(node.getId(), node);
                this.model.add(initialNodeStatus);
                this.allChecks.put(node.getId(), healthCheck);
            }
            finally {
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            LOG.log(Debug.getDebugLogLevel(), String.format("Exception while adding Node %s", node.getUri()), e);
            return;
        }
        this.updateNodeAvailability(initialNodeStatus.getExternalUri(), initialNodeStatus.getNodeId(), initialNodeStatus.getAvailability());
        LOG.info(String.format("Added node %s at %s. Health check every %ss", node.getId(), node.getUri(), this.healthcheckInterval.toMillis() / 1000L));
        this.bus.fire(new NodeAddedEvent(node.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(NodeId nodeId) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Node node = this.nodes.remove(nodeId);
            this.model.remove(nodeId);
            this.allChecks.remove(nodeId);
            if (node instanceof RemoteNode) {
                try {
                    ((RemoteNode)node).close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to close node properly: " + e.getMessage());
                }
            }
            LOG.info(String.format("Node %s removed and all resources cleaned up", nodeId));
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drain(NodeId nodeId) {
        Node node = this.nodes.get(nodeId);
        if (node == null) {
            LOG.info("Asked to drain unregistered node " + String.valueOf(nodeId));
            return false;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            node.drain();
            this.model.setAvailability(nodeId, Availability.DRAINING);
        }
        finally {
            writeLock.unlock();
        }
        return node.isDraining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAvailability(URI nodeUri, NodeId id, Availability availability) {
        Require.nonNull("Node URI", nodeUri);
        Require.nonNull("Node ID", id);
        Require.nonNull("Availability", availability);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            LOG.log(Debug.getDebugLogLevel(), String.format("Health check result for %s was %s", new Object[]{nodeUri, availability}));
            this.model.setAvailability(id, availability);
            this.model.updateHealthCheckCount(id, availability);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void runHealthChecks() {
        ImmutableMap<NodeId, Runnable> nodeHealthChecks;
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            nodeHealthChecks = ImmutableMap.copyOf(this.allChecks);
        }
        finally {
            readLock.unlock();
        }
        if (nodeHealthChecks.isEmpty()) {
            return;
        }
        ArrayList<Runnable> checks = new ArrayList<Runnable>(nodeHealthChecks.values());
        int total = checks.size();
        int batchSize = Math.max(10, total / 10);
        List<List<Runnable>> batches = LocalNodeRegistry.partition(checks, batchSize);
        this.processBatchesInParallel(batches);
    }

    @Override
    public void refresh() {
        ArrayList<Runnable> allHealthChecks = new ArrayList<Runnable>();
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            allHealthChecks.addAll(this.allChecks.values());
        }
        finally {
            readLock.unlock();
        }
        allHealthChecks.parallelStream().forEach(Runnable::run);
    }

    @Override
    public DistributorStatus getStatus() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            DistributorStatus distributorStatus = new DistributorStatus(this.model.getSnapshot());
            return distributorStatus;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Set<NodeStatus> getAvailableNodes() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set set = this.model.getSnapshot().stream().filter(node -> Availability.UP.equals((Object)node.getAvailability()) && node.hasCapacity()).collect(ImmutableSet.toImmutableSet());
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Node getNode(NodeId id) {
        return this.nodes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUpNodeCount() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            long l = this.model.getSnapshot().stream().filter(node -> Availability.UP.equals((Object)node.getAvailability())).collect(Collectors.toSet()).size();
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDownNodeCount() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            long l = this.model.getSnapshot().stream().filter(node -> Availability.DOWN.equals((Object)node.getAvailability())).collect(Collectors.toSet()).size();
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean isReady() {
        try {
            return ImmutableSet.of(this.bus).parallelStream().map(HasReadyState::isReady).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private void processBatchesInParallel(List<List<Runnable>> batches) {
        if (batches.isEmpty()) {
            return;
        }
        batches.forEach(batch -> this.nodeHealthCheckExecutor.submit(() -> batch.parallelStream().forEach(r -> {
            try {
                r.run();
            }
            catch (Throwable t2) {
                LOG.log(Debug.getDebugLogLevel(), "Health check execution failed in batch", t2);
            }
        })));
    }

    private static List<List<Runnable>> partition(List<Runnable> list, int size) {
        ArrayList<List<Runnable>> batches = new ArrayList<List<Runnable>>();
        if (list.isEmpty() || size <= 0) {
            return batches;
        }
        for (int i = 0; i < list.size(); i += size) {
            int end = Math.min(i + size, list.size());
            batches.add(new ArrayList<Runnable>(list.subList(i, end)));
        }
        return batches;
    }

    private Runnable asRunnableHealthCheck(Node node) {
        HealthCheck healthCheck = node.getHealthCheck();
        NodeId id = node.getId();
        return () -> {
            HealthCheck.Result result;
            boolean checkFailed = false;
            Exception failedCheckException = null;
            LOG.log(Debug.getDebugLogLevel(), "Running healthcheck for Node " + String.valueOf(node.getUri()));
            try {
                result = healthCheck.check();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to process Node healthcheck " + String.valueOf(id), e);
                result = new HealthCheck.Result(Availability.DOWN, "Unable to run healthcheck. Assuming down");
                checkFailed = true;
                failedCheckException = e;
            }
            this.updateNodeAvailability(node.getUri(), id, result.getAvailability());
            if (checkFailed) {
                throw new HealthCheckFailedException("Node " + String.valueOf(id), failedCheckException);
            }
        };
    }

    public GridModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reserve(SlotId slotId) {
        Require.nonNull("Slot ID", slotId);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            NodeId nodeId = slotId.getOwningNodeId();
            Node node = this.nodes.get(nodeId);
            if (node == null) {
                LOG.log(Debug.getDebugLogLevel(), String.format("Unable to find node with id %s", slotId));
                boolean bl = false;
                return bl;
            }
            boolean bl = this.model.reserve(slotId);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSession(SlotId slotId, Session session) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.model.setSession(slotId, session);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int getActiveSlots() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = this.model.getSnapshot().stream().map(NodeStatus::getSlots).flatMap(Collection::stream).filter(slot -> slot.getSession() != null).filter(slot -> !slot.getSession().getId().equals(RESERVED)).mapToInt(slot -> 1).sum();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public int getIdleSlots() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = (int)(this.model.getSnapshot().stream().flatMap(status -> status.getSlots().stream()).count() - (long)this.getActiveSlots());
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(URI uri) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Optional<NodeStatus> nodeStatus = this.model.getSnapshot().stream().filter(node -> node.getExternalUri().equals(uri)).findFirst();
            Node node2 = nodeStatus.map(status -> this.nodes.get(status.getNodeId())).orElse(null);
            return node2;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void close() {
        LOG.info("Shutting down LocalNodeRegistry");
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.allChecks.clear();
            this.nodes.values().forEach(n -> {
                if (n instanceof RemoteNode) {
                    try {
                        ((RemoteNode)n).close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Unable to close node properly: " + e.getMessage());
                    }
                }
            });
            this.nodes.clear();
        }
        finally {
            writeLock.unlock();
        }
    }
}

