/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProxyOutputStreamTest {
    private ByteArrayOutputStream original;
    private OutputStream proxied;

    @BeforeEach
    public void setUp() {
        this.original = new ByteArrayOutputStream(){

            @Override
            public void write(byte[] ba) throws IOException {
                if (ba != null) {
                    super.write(ba);
                }
            }
        };
        this.proxied = new ProxyOutputStream(this.original);
    }

    @Test
    public void testWrite() throws Exception {
        this.proxied.write(121);
        Assertions.assertEquals((int)1, (int)this.original.size());
        Assertions.assertEquals((int)121, (int)this.original.toByteArray()[0]);
    }

    @Test
    public void testWriteNullBaSucceeds() throws Exception {
        byte[] ba = null;
        this.original.write(ba);
        this.proxied.write(ba);
    }
}

