package org.openqa.selenium.devtools.v131.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for a issue arising from an SAB being instantiated in, or
 * transferred to a context that is not cross-origin isolated.
 */
public class SharedArrayBufferIssueDetails {

    private final org.openqa.selenium.devtools.v131.audits.model.SourceCodeLocation sourceCodeLocation;

    private final java.lang.Boolean isWarning;

    private final org.openqa.selenium.devtools.v131.audits.model.SharedArrayBufferIssueType type;

    public SharedArrayBufferIssueDetails(org.openqa.selenium.devtools.v131.audits.model.SourceCodeLocation sourceCodeLocation, java.lang.Boolean isWarning, org.openqa.selenium.devtools.v131.audits.model.SharedArrayBufferIssueType type) {
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.isWarning = java.util.Objects.requireNonNull(isWarning, "isWarning is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    public org.openqa.selenium.devtools.v131.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    public java.lang.Boolean getIsWarning() {
        return isWarning;
    }

    public org.openqa.selenium.devtools.v131.audits.model.SharedArrayBufferIssueType getType() {
        return type;
    }

    private static SharedArrayBufferIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v131.audits.model.SourceCodeLocation sourceCodeLocation = null;
        java.lang.Boolean isWarning = false;
        org.openqa.selenium.devtools.v131.audits.model.SharedArrayBufferIssueType type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v131.audits.model.SourceCodeLocation.class);
                    break;
                case "isWarning":
                    isWarning = input.nextBoolean();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v131.audits.model.SharedArrayBufferIssueType.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedArrayBufferIssueDetails(sourceCodeLocation, isWarning, type);
    }
}
