package org.openqa.selenium.devtools.v135.autofill.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class FilledField {

    private final java.lang.String htmlType;

    private final java.lang.String id;

    private final java.lang.String name;

    private final java.lang.String value;

    private final java.lang.String autofillType;

    private final org.openqa.selenium.devtools.v135.autofill.model.FillingStrategy fillingStrategy;

    private final org.openqa.selenium.devtools.v135.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.v135.dom.model.BackendNodeId fieldId;

    public FilledField(java.lang.String htmlType, java.lang.String id, java.lang.String name, java.lang.String value, java.lang.String autofillType, org.openqa.selenium.devtools.v135.autofill.model.FillingStrategy fillingStrategy, org.openqa.selenium.devtools.v135.page.model.FrameId frameId, org.openqa.selenium.devtools.v135.dom.model.BackendNodeId fieldId) {
        this.htmlType = java.util.Objects.requireNonNull(htmlType, "htmlType is required");
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.autofillType = java.util.Objects.requireNonNull(autofillType, "autofillType is required");
        this.fillingStrategy = java.util.Objects.requireNonNull(fillingStrategy, "fillingStrategy is required");
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.fieldId = java.util.Objects.requireNonNull(fieldId, "fieldId is required");
    }

    /**
     * The type of the field, e.g text, password etc.
     */
    public java.lang.String getHtmlType() {
        return htmlType;
    }

    /**
     * the html id
     */
    public java.lang.String getId() {
        return id;
    }

    /**
     * the html name
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * the field value
     */
    public java.lang.String getValue() {
        return value;
    }

    /**
     * The actual field type, e.g FAMILY_NAME
     */
    public java.lang.String getAutofillType() {
        return autofillType;
    }

    /**
     * The filling strategy
     */
    public org.openqa.selenium.devtools.v135.autofill.model.FillingStrategy getFillingStrategy() {
        return fillingStrategy;
    }

    /**
     * The frame the field belongs to
     */
    public org.openqa.selenium.devtools.v135.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * The form field's DOM node
     */
    public org.openqa.selenium.devtools.v135.dom.model.BackendNodeId getFieldId() {
        return fieldId;
    }

    private static FilledField fromJson(JsonInput input) {
        java.lang.String htmlType = null;
        java.lang.String id = null;
        java.lang.String name = null;
        java.lang.String value = null;
        java.lang.String autofillType = null;
        org.openqa.selenium.devtools.v135.autofill.model.FillingStrategy fillingStrategy = null;
        org.openqa.selenium.devtools.v135.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.v135.dom.model.BackendNodeId fieldId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "htmlType":
                    htmlType = input.nextString();
                    break;
                case "id":
                    id = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextString();
                    break;
                case "autofillType":
                    autofillType = input.nextString();
                    break;
                case "fillingStrategy":
                    fillingStrategy = input.read(org.openqa.selenium.devtools.v135.autofill.model.FillingStrategy.class);
                    break;
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v135.page.model.FrameId.class);
                    break;
                case "fieldId":
                    fieldId = input.read(org.openqa.selenium.devtools.v135.dom.model.BackendNodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FilledField(htmlType, id, name, value, autofillType, fillingStrategy, frameId, fieldId);
    }
}
