package org.openqa.selenium.devtools.v135.autofill.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Emitted when an address form is filled.
 */
public class AddressFormFilled {

    private final java.util.List<org.openqa.selenium.devtools.v135.autofill.model.FilledField> filledFields;

    private final org.openqa.selenium.devtools.v135.autofill.model.AddressUI addressUi;

    public AddressFormFilled(java.util.List<org.openqa.selenium.devtools.v135.autofill.model.FilledField> filledFields, org.openqa.selenium.devtools.v135.autofill.model.AddressUI addressUi) {
        this.filledFields = java.util.Objects.requireNonNull(filledFields, "filledFields is required");
        this.addressUi = java.util.Objects.requireNonNull(addressUi, "addressUi is required");
    }

    /**
     * Information about the fields that were filled
     */
    public java.util.List<org.openqa.selenium.devtools.v135.autofill.model.FilledField> getFilledFields() {
        return filledFields;
    }

    /**
     * An UI representation of the address used to fill the form.
     * Consists of a 2D array where each child represents an address/profile line.
     */
    public org.openqa.selenium.devtools.v135.autofill.model.AddressUI getAddressUi() {
        return addressUi;
    }

    private static AddressFormFilled fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v135.autofill.model.FilledField> filledFields = null;
        org.openqa.selenium.devtools.v135.autofill.model.AddressUI addressUi = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "filledFields":
                    filledFields = input.readArray(org.openqa.selenium.devtools.v135.autofill.model.FilledField.class);
                    break;
                case "addressUi":
                    addressUi = input.read(org.openqa.selenium.devtools.v135.autofill.model.AddressUI.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AddressFormFilled(filledFields, addressUi);
    }
}
