package org.openqa.selenium.devtools.v134.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about the Resource on the page.
 */
@org.openqa.selenium.Beta()
public class FrameResource {

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v134.network.model.ResourceType type;

    private final java.lang.String mimeType;

    private final java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch> lastModified;

    private final java.util.Optional<java.lang.Number> contentSize;

    private final java.util.Optional<java.lang.Boolean> failed;

    private final java.util.Optional<java.lang.Boolean> canceled;

    public FrameResource(java.lang.String url, org.openqa.selenium.devtools.v134.network.model.ResourceType type, java.lang.String mimeType, java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch> lastModified, java.util.Optional<java.lang.Number> contentSize, java.util.Optional<java.lang.Boolean> failed, java.util.Optional<java.lang.Boolean> canceled) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.mimeType = java.util.Objects.requireNonNull(mimeType, "mimeType is required");
        this.lastModified = lastModified;
        this.contentSize = contentSize;
        this.failed = failed;
        this.canceled = canceled;
    }

    /**
     * Resource URL.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Type of this resource.
     */
    public org.openqa.selenium.devtools.v134.network.model.ResourceType getType() {
        return type;
    }

    /**
     * Resource mimeType as determined by the browser.
     */
    public java.lang.String getMimeType() {
        return mimeType;
    }

    /**
     * last-modified timestamp as reported by server.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch> getLastModified() {
        return lastModified;
    }

    /**
     * Resource content size.
     */
    public java.util.Optional<java.lang.Number> getContentSize() {
        return contentSize;
    }

    /**
     * True if the resource failed to load.
     */
    public java.util.Optional<java.lang.Boolean> getFailed() {
        return failed;
    }

    /**
     * True if the resource was canceled during loading.
     */
    public java.util.Optional<java.lang.Boolean> getCanceled() {
        return canceled;
    }

    private static FrameResource fromJson(JsonInput input) {
        java.lang.String url = null;
        org.openqa.selenium.devtools.v134.network.model.ResourceType type = null;
        java.lang.String mimeType = null;
        java.util.Optional<org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch> lastModified = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> contentSize = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> failed = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> canceled = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v134.network.model.ResourceType.class);
                    break;
                case "mimeType":
                    mimeType = input.nextString();
                    break;
                case "lastModified":
                    lastModified = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v134.network.model.TimeSinceEpoch.class));
                    break;
                case "contentSize":
                    contentSize = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "failed":
                    failed = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "canceled":
                    canceled = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameResource(url, type, mimeType, lastModified, contentSize, failed, canceled);
    }
}
