/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.timer;

import org.zeromq.timer.TimerHandler;
import org.zeromq.timer.ZTicket;
import org.zeromq.timer.ZTimer;
import zmq.util.function.Supplier;

public final class ZTicker {
    private final ZTimer timer;
    private final ZTicket ticket;

    public ZTicker() {
        this.timer = new ZTimer();
        this.ticket = new ZTicket();
    }

    ZTicker(Supplier<Long> clock) {
        this.timer = new ZTimer(clock);
        this.ticket = new ZTicket(clock);
    }

    public ZTicket.Ticket addTicket(long interval, TimerHandler handler, Object ... args) {
        return this.ticket.add(interval, handler, args);
    }

    public ZTimer.Timer addTimer(long interval, TimerHandler handler, Object ... args) {
        return this.timer.add(interval, handler, args);
    }

    public long timeout() {
        long timer = this.timer.timeout();
        long ticket = this.ticket.timeout();
        if (timer < 0L || ticket < 0L) {
            return Math.max(timer, ticket);
        }
        return Math.min(timer, ticket);
    }

    public int execute() {
        return this.timer.execute() + this.ticket.execute();
    }
}

