/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByAll
extends By
implements Serializable {
    private static final long serialVersionUID = 4573668832699497306L;
    private final By[] bys;

    public ByAll(By ... bys) {
        this.bys = bys;
    }

    @Override
    public WebElement findElement(SearchContext context) {
        for (By by : this.bys) {
            List<WebElement> elements = context.findElements(by);
            if (elements.isEmpty()) continue;
            return elements.get(0);
        }
        throw new NoSuchElementException("Cannot locate an element using " + String.valueOf(this));
    }

    @Override
    public List<WebElement> findElements(SearchContext context) {
        ArrayList<WebElement> elems = new ArrayList<WebElement>();
        for (By by : this.bys) {
            elems.addAll(context.findElements(by));
        }
        return elems;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("By.all(");
        stringBuilder.append("{");
        boolean first = true;
        for (By by : this.bys) {
            stringBuilder.append(first ? "" : ",").append(by);
            first = false;
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }
}

