/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.Optional;
import java.util.function.Supplier;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.CacheKey;
import org.dataloader.CacheMap;
import org.dataloader.ValueCache;
import org.dataloader.ValueCacheOptions;
import org.dataloader.annotations.PublicApi;
import org.dataloader.impl.Assertions;
import org.dataloader.scheduler.BatchLoaderScheduler;
import org.dataloader.stats.NoOpStatisticsCollector;
import org.dataloader.stats.StatisticsCollector;

@PublicApi
public class DataLoaderOptions {
    private static final BatchLoaderContextProvider NULL_PROVIDER = () -> null;
    private boolean batchingEnabled;
    private boolean cachingEnabled;
    private boolean cachingExceptionsEnabled;
    private CacheKey<?> cacheKeyFunction;
    private CacheMap<?, ?> cacheMap;
    private ValueCache<?, ?> valueCache;
    private int maxBatchSize;
    private Supplier<StatisticsCollector> statisticsCollector;
    private BatchLoaderContextProvider environmentProvider;
    private ValueCacheOptions valueCacheOptions;
    private BatchLoaderScheduler batchLoaderScheduler;

    public DataLoaderOptions() {
        this.batchingEnabled = true;
        this.cachingEnabled = true;
        this.cachingExceptionsEnabled = true;
        this.maxBatchSize = -1;
        this.statisticsCollector = NoOpStatisticsCollector::new;
        this.environmentProvider = NULL_PROVIDER;
        this.valueCacheOptions = ValueCacheOptions.newOptions();
        this.batchLoaderScheduler = null;
    }

    public DataLoaderOptions(DataLoaderOptions other) {
        Assertions.nonNull(other);
        this.batchingEnabled = other.batchingEnabled;
        this.cachingEnabled = other.cachingEnabled;
        this.cachingExceptionsEnabled = other.cachingExceptionsEnabled;
        this.cacheKeyFunction = other.cacheKeyFunction;
        this.cacheMap = other.cacheMap;
        this.valueCache = other.valueCache;
        this.maxBatchSize = other.maxBatchSize;
        this.statisticsCollector = other.statisticsCollector;
        this.environmentProvider = other.environmentProvider;
        this.valueCacheOptions = other.valueCacheOptions;
        this.batchLoaderScheduler = other.batchLoaderScheduler;
    }

    public static DataLoaderOptions newOptions() {
        return new DataLoaderOptions();
    }

    public boolean batchingEnabled() {
        return this.batchingEnabled;
    }

    public DataLoaderOptions setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
        return this;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    public DataLoaderOptions setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public boolean cachingExceptionsEnabled() {
        return this.cachingExceptionsEnabled;
    }

    public DataLoaderOptions setCachingExceptionsEnabled(boolean cachingExceptionsEnabled) {
        this.cachingExceptionsEnabled = cachingExceptionsEnabled;
        return this;
    }

    public Optional<CacheKey> cacheKeyFunction() {
        return Optional.ofNullable(this.cacheKeyFunction);
    }

    public DataLoaderOptions setCacheKeyFunction(CacheKey<?> cacheKeyFunction) {
        this.cacheKeyFunction = cacheKeyFunction;
        return this;
    }

    public Optional<CacheMap<?, ?>> cacheMap() {
        return Optional.ofNullable(this.cacheMap);
    }

    public DataLoaderOptions setCacheMap(CacheMap<?, ?> cacheMap) {
        this.cacheMap = cacheMap;
        return this;
    }

    public int maxBatchSize() {
        return this.maxBatchSize;
    }

    public DataLoaderOptions setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    public StatisticsCollector getStatisticsCollector() {
        return Assertions.nonNull(this.statisticsCollector.get());
    }

    public DataLoaderOptions setStatisticsCollector(Supplier<StatisticsCollector> statisticsCollector) {
        this.statisticsCollector = Assertions.nonNull(statisticsCollector);
        return this;
    }

    public BatchLoaderContextProvider getBatchLoaderContextProvider() {
        return this.environmentProvider;
    }

    public DataLoaderOptions setBatchLoaderContextProvider(BatchLoaderContextProvider contextProvider) {
        this.environmentProvider = Assertions.nonNull(contextProvider);
        return this;
    }

    public Optional<ValueCache<?, ?>> valueCache() {
        return Optional.ofNullable(this.valueCache);
    }

    public DataLoaderOptions setValueCache(ValueCache<?, ?> valueCache) {
        this.valueCache = valueCache;
        return this;
    }

    public ValueCacheOptions getValueCacheOptions() {
        return this.valueCacheOptions;
    }

    public DataLoaderOptions setValueCacheOptions(ValueCacheOptions valueCacheOptions) {
        this.valueCacheOptions = Assertions.nonNull(valueCacheOptions);
        return this;
    }

    public BatchLoaderScheduler getBatchLoaderScheduler() {
        return this.batchLoaderScheduler;
    }

    public DataLoaderOptions setBatchLoaderScheduler(BatchLoaderScheduler batchLoaderScheduler) {
        this.batchLoaderScheduler = batchLoaderScheduler;
        return this;
    }
}

