/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.io.serialization.AbstractCloseableListTest;
import org.apache.commons.io.serialization.MoreComplexObject;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MoreComplexObjectTest
extends AbstractCloseableListTest {
    private InputStream inputStream;
    private MoreComplexObject original;

    private void assertSerialization(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        MoreComplexObject copy = (MoreComplexObject)ois.readObject();
        Assertions.assertEquals((Object)this.original.toString(), (Object)copy.toString(), (String)"Expecting same data after deserializing");
    }

    @BeforeEach
    public void setupMoreComplexObject() throws IOException {
        this.original = new MoreComplexObject();
        ByteArrayOutputStream bos = this.addCloseable(new ByteArrayOutputStream());
        ObjectOutputStream oos = this.addCloseable(new ObjectOutputStream(bos));
        oos.writeObject(this.original);
        this.inputStream = this.addCloseable(new ByteArrayInputStream(bos.toByteArray()));
    }

    @Test
    public void testTrustJavaIncludingArrays() throws IOException, ClassNotFoundException {
        this.assertSerialization((ObjectInputStream)this.addCloseable(((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setInputStream(this.inputStream)).accept(new Class[]{MoreComplexObject.class}).accept(new String[]{"java.*", "[Ljava.*"}).get()));
    }

    @Test
    public void testTrustJavaLang() throws IOException, ClassNotFoundException {
        this.assertSerialization((ObjectInputStream)this.addCloseable(((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setInputStream(this.inputStream)).accept(new Class[]{MoreComplexObject.class, ArrayList.class, Random.class}).accept(new String[]{"java.lang.*", "[Ljava.lang.*"}).get()));
    }

    @Test
    public void testUseBlacklist() throws IOException, ClassNotFoundException {
        String[] blacklist = new String[]{"org.apache.commons.collections.functors.InvokerTransformer", "org.codehaus.groovy.runtime.ConvertedClosure", "org.codehaus.groovy.runtime.MethodClosure", "org.springframework.beans.factory.ObjectFactory"};
        this.assertSerialization((ObjectInputStream)this.addCloseable(((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setInputStream(this.inputStream)).accept(new String[]{"*"}).reject(blacklist).get()));
    }
}

