/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.input.TaggedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedInputStreamTest {
    @Test
    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedInputStream stream = new TaggedInputStream((InputStream)new BrokenInputStream(exception));
        IOException exceptionAvailable = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedInputStream)stream).available());
        Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)exceptionAvailable));
        IOException exceptionAvailableCause = (IOException)Assertions.assertThrows(IOException.class, () -> stream.throwIfCauseOf((Throwable)exceptionAvailable));
        Assertions.assertEquals((Object)exception, (Object)exceptionAvailableCause);
        IOException exceptionRead = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedInputStream)stream).read());
        Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)exceptionRead));
        IOException exceptionReadCause = (IOException)Assertions.assertThrows(IOException.class, () -> stream.throwIfCauseOf((Throwable)exceptionRead));
        Assertions.assertEquals((Object)exception, (Object)exceptionReadCause);
        IOException exceptionClose = (IOException)Assertions.assertThrows(IOException.class, () -> ((TaggedInputStream)stream).close());
        Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)exceptionClose));
        IOException exceptionCloseCause = (IOException)Assertions.assertThrows(IOException.class, () -> stream.throwIfCauseOf((Throwable)exceptionClose));
        Assertions.assertEquals((Object)exception, (Object)exceptionCloseCause);
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException((ProxyInputStream)new TaggedInputStream((InputStream)new BrokenInputStream((Throwable)new IOException())));
    }

    @Test
    public void testEmptyStream() throws IOException {
        try (TaggedInputStream stream = new TaggedInputStream((InputStream)ClosedInputStream.INSTANCE);){
            Assertions.assertEquals((int)0, (int)stream.available());
            Assertions.assertEquals((int)-1, (int)stream.read());
            Assertions.assertEquals((int)-1, (int)stream.read(new byte[1]));
            Assertions.assertEquals((int)-1, (int)stream.read(new byte[1], 0, 1));
        }
    }

    @Test
    public void testNormalStream() throws IOException {
        try (TaggedInputStream stream = new TaggedInputStream((InputStream)new ByteArrayInputStream(new byte[]{97, 98, 99}));){
            Assertions.assertEquals((int)3, (int)stream.available());
            Assertions.assertEquals((int)97, (int)stream.read());
            byte[] buffer = new byte[1];
            Assertions.assertEquals((int)1, (int)stream.read(buffer));
            Assertions.assertEquals((int)98, (int)buffer[0]);
            Assertions.assertEquals((int)1, (int)stream.read(buffer, 0, 1));
            Assertions.assertEquals((int)99, (int)buffer[0]);
            Assertions.assertEquals((int)-1, (int)stream.read());
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedInputStream stream = new TaggedInputStream((InputStream)ClosedInputStream.INSTANCE);){
            Assertions.assertFalse((boolean)stream.isCauseOf((Throwable)exception));
            Assertions.assertFalse((boolean)stream.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
            stream.throwIfCauseOf((Throwable)exception);
            stream.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
    }
}

