/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.util.StringUtils;

public class NullInputStreamTest {
    private static final String MARK_RESET_NOT_SUPPORTED = "mark/reset not supported";

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterClose(int len) throws Exception {
        TestNullInputStream shadow;
        try (TestNullInputStream in = new TestNullInputStream(len, false, false);){
            Assertions.assertEquals((int)len, (int)((InputStream)((Object)in)).available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)shadow)).available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterOpen(int len) throws Exception {
        try (TestNullInputStream in = new TestNullInputStream(len, false, false);){
            Assertions.assertEquals((int)len, (int)((InputStream)((Object)in)).available());
        }
    }

    @Test
    public void testDeprecatedSingleton() throws Exception {
        Assertions.assertNotNull((Object)NullInputStream.INSTANCE);
    }

    @Test
    public void testEOFException() throws Exception {
        try (TestNullInputStream input = new TestNullInputStream(2, false, true);){
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).read(), (String)"Read 1");
            Assertions.assertEquals((int)1, (int)((InputStream)((Object)input)).read(), (String)"Read 2");
            Assertions.assertThrows(EOFException.class, () -> NullInputStreamTest.lambda$testEOFException$0((InputStream)((Object)input)));
        }
    }

    @Test
    public void testMarkAndReset() throws Exception {
        int readLimit = 10;
        try (TestNullInputStream input = new TestNullInputStream(100, true, false);){
            int i;
            int position;
            Assertions.assertTrue((boolean)((InputStream)((Object)input)).markSupported(), (String)"Mark Should be Supported");
            IOException noMarkException = (IOException)Assertions.assertThrows(IOException.class, ((InputStream)((Object)input))::reset);
            Assertions.assertEquals((Object)"No position has been marked", (Object)noMarkException.getMessage(), (String)"No Mark IOException message");
            for (position = 0; position < 3; ++position) {
                Assertions.assertEquals((int)position, (int)((InputStream)((Object)input)).read(), (String)("Read Before Mark [" + position + "]"));
            }
            ((InputStream)((Object)input)).mark(10);
            for (i = 0; i < 3; ++i) {
                Assertions.assertEquals((int)(position + i), (int)((InputStream)((Object)input)).read(), (String)("Read After Mark [" + i + "]"));
            }
            ((InputStream)((Object)input)).reset();
            for (i = 0; i < 11; ++i) {
                Assertions.assertEquals((int)(position + i), (int)((InputStream)((Object)input)).read(), (String)("Read After Reset [" + i + "]"));
            }
            IOException resetException = (IOException)Assertions.assertThrows(IOException.class, ((InputStream)((Object)input))::reset, (String)"Read limit exceeded, expected IOException");
            Assertions.assertEquals((Object)("Marked position [" + position + "] is no longer valid - passed the read limit [" + 10 + "]"), (Object)resetException.getMessage(), (String)"Read limit IOException message");
        }
    }

    @Test
    public void testMarkNotSupported() throws Exception {
        try (TestNullInputStream input = new TestNullInputStream(100, false, true);){
            Assertions.assertFalse((boolean)((InputStream)((Object)input)).markSupported(), (String)"Mark Should NOT be Supported");
            UnsupportedOperationException markException = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> NullInputStreamTest.lambda$testMarkNotSupported$1((InputStream)((Object)input)));
            Assertions.assertEquals((Object)MARK_RESET_NOT_SUPPORTED, (Object)markException.getMessage(), (String)"mark() error message");
            UnsupportedOperationException resetException = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, ((InputStream)((Object)input))::reset);
            Assertions.assertEquals((Object)MARK_RESET_NOT_SUPPORTED, (Object)resetException.getMessage(), (String)"reset() error message");
        }
    }

    @Test
    public void testRead() throws Exception {
        int size = 5;
        try (TestNullInputStream input = new TestNullInputStream(5);){
            for (int i = 0; i < 5; ++i) {
                Assertions.assertEquals((int)(5 - i), (int)((InputStream)((Object)input)).available(), (String)("Check Size [" + i + "]"));
                Assertions.assertEquals((int)i, (int)((InputStream)((Object)input)).read(), (String)("Check Value [" + i + "]"));
            }
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after contents all read");
            Assertions.assertEquals((int)-1, (int)((InputStream)((Object)input)).read(), (String)"End of File");
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after End of File");
            Assertions.assertEquals((int)-1, (int)((InputStream)((Object)input)).read(), (String)"End of File");
            ((InputStream)((Object)input)).close();
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after close");
        }
    }

    @Test
    public void testReadAfterClose() throws Exception {
        try (NullInputStream in = new NullInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            in.close();
            Assertions.assertThrows(IOException.class, ((InputStream)in)::read);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadAfterClose(int len) throws Exception {
        try (TestNullInputStream in = new TestNullInputStream(len, false, false);){
            Assertions.assertEquals((int)len, (int)((InputStream)((Object)in)).available());
            ((InputStream)((Object)in)).close();
            Assertions.assertThrows(IOException.class, ((InputStream)((Object)in))::read);
        }
    }

    @Test
    public void testReadByteArray() throws Exception {
        byte[] bytes = new byte[10];
        try (TestNullInputStream input = new TestNullInputStream(15);){
            int count1 = input.read(bytes);
            Assertions.assertEquals((int)bytes.length, (int)count1, (String)"Read 1");
            for (int i = 0; i < count1; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 1");
            }
            int count2 = input.read(bytes);
            Assertions.assertEquals((int)5, (int)count2, (String)"Read 2");
            for (int i = 0; i < count2; ++i) {
                Assertions.assertEquals((int)(count1 + i), (int)bytes[i], (String)"Check Bytes 2");
            }
            int count3 = input.read(bytes);
            Assertions.assertEquals((int)-1, (int)count3, (String)"Read 3 (EOF)");
            int count4 = input.read(bytes);
            Assertions.assertEquals((int)-1, (int)count4, (String)"Read 4 (EOF)");
            input.init();
            int offset = 2;
            int len = 4;
            int count5 = input.read(bytes, 2, 4);
            Assertions.assertEquals((int)4, (int)count5, (String)"Read 5");
            for (int i = 2; i < 4; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 2");
            }
        }
    }

    @Test
    public void testReadByteArrayAfterClose() throws Exception {
        try (NullInputStream in = new NullInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0]));
            Assertions.assertThrows(IOException.class, () -> NullInputStreamTest.lambda$testReadByteArrayAfterClose$2((InputStream)in));
        }
    }

    @Test
    public void testReadByteArrayIntIntAfterClose() throws Exception {
        try (NullInputStream in = new NullInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0], 0, 1));
            Assertions.assertEquals((int)0, (int)in.read(new byte[1], 0, 0));
            Assertions.assertThrows(IOException.class, () -> NullInputStreamTest.lambda$testReadByteArrayIntIntAfterClose$3((InputStream)in));
        }
    }

    @Test
    public void testReadByteArrayThrowAtEof() throws Exception {
        byte[] bytes = new byte[10];
        try (TestNullInputStream input = new TestNullInputStream(15, true, true);){
            int count1 = input.read(bytes);
            Assertions.assertEquals((int)bytes.length, (int)count1, (String)"Read 1");
            for (int i = 0; i < count1; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 1");
            }
            int count2 = input.read(bytes);
            Assertions.assertEquals((int)5, (int)count2, (String)"Read 2");
            for (int i = 0; i < count2; ++i) {
                Assertions.assertEquals((int)(count1 + i), (int)bytes[i], (String)"Check Bytes 2");
            }
            IOException e1 = (IOException)Assertions.assertThrows(EOFException.class, () -> input.read(bytes));
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e1.getMessage()));
            IOException e2 = (IOException)Assertions.assertThrows(EOFException.class, () -> input.read(bytes));
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e2.getMessage()));
            input.init();
            int offset = 2;
            int len = 4;
            int count5 = input.read(bytes, 2, 4);
            Assertions.assertEquals((int)4, (int)count5, (String)"Read 5");
            for (int i = 2; i < 4; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 2");
            }
        }
    }

    @Test
    public void testReadThrowAtEof() throws Exception {
        int size = 5;
        try (TestNullInputStream input = new TestNullInputStream(5, true, true);){
            for (int i = 0; i < 5; ++i) {
                Assertions.assertEquals((int)(5 - i), (int)((InputStream)((Object)input)).available(), (String)("Check Size [" + i + "]"));
                Assertions.assertEquals((int)i, (int)((InputStream)((Object)input)).read(), (String)("Check Value [" + i + "]"));
            }
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after contents all read");
            IOException e1 = (IOException)Assertions.assertThrows(EOFException.class, ((InputStream)((Object)input))::read);
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e1.getMessage()));
            IOException e2 = (IOException)Assertions.assertThrows(EOFException.class, ((InputStream)((Object)input))::read);
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e2.getMessage()));
            ((InputStream)((Object)input)).close();
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after close");
        }
    }

    @Test
    public void testSkip() throws Exception {
        try (TestNullInputStream input = new TestNullInputStream(10, true, false);){
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).read(), (String)"Read 1");
            Assertions.assertEquals((int)1, (int)((InputStream)((Object)input)).read(), (String)"Read 2");
            Assertions.assertEquals((long)5L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 1");
            Assertions.assertEquals((int)7, (int)((InputStream)((Object)input)).read(), (String)"Read 3");
            Assertions.assertEquals((long)2L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 2");
            Assertions.assertEquals((long)-1L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 3 (EOF)");
            Assertions.assertEquals((long)-1L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 3 (EOF)");
        }
    }

    @Test
    public void testSkipThrowAtEof() throws Exception {
        try (TestNullInputStream input = new TestNullInputStream(10, true, true);){
            Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).read(), (String)"Read 1");
            Assertions.assertEquals((int)1, (int)((InputStream)((Object)input)).read(), (String)"Read 2");
            Assertions.assertEquals((long)5L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 1");
            Assertions.assertEquals((int)7, (int)((InputStream)((Object)input)).read(), (String)"Read 3");
            Assertions.assertEquals((long)2L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 2");
            IOException e1 = (IOException)Assertions.assertThrows(EOFException.class, () -> NullInputStreamTest.lambda$testSkipThrowAtEof$6((InputStream)((Object)input)), (String)"Skip 3 (EOF)");
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e1.getMessage()));
            IOException e2 = (IOException)Assertions.assertThrows(IOException.class, () -> NullInputStreamTest.lambda$testSkipThrowAtEof$7((InputStream)((Object)input)), (String)"Expected IOException for skipping after end of file");
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((String)e2.getMessage()));
        }
    }

    private static /* synthetic */ void lambda$testSkipThrowAtEof$7(InputStream input) throws Throwable {
        input.skip(5L);
    }

    private static /* synthetic */ void lambda$testSkipThrowAtEof$6(InputStream input) throws Throwable {
        input.skip(5L);
    }

    private static /* synthetic */ void lambda$testReadByteArrayIntIntAfterClose$3(InputStream in) throws Throwable {
        in.read(new byte[2], 0, 1);
    }

    private static /* synthetic */ void lambda$testReadByteArrayAfterClose$2(InputStream in) throws Throwable {
        in.read(new byte[2]);
    }

    private static /* synthetic */ void lambda$testMarkNotSupported$1(InputStream input) throws Throwable {
        input.mark(5);
    }

    private static /* synthetic */ void lambda$testEOFException$0(InputStream input) throws Throwable {
        input.read();
    }

    private static final class TestNullInputStream
    extends NullInputStream {
        TestNullInputStream(int size) {
            super((long)size);
        }

        TestNullInputStream(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processByte() {
            return (int)this.getPosition() - 1;
        }

        protected void processBytes(byte[] bytes, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                bytes[i] = (byte)(startPos + i);
            }
        }
    }
}

