/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CloseShieldInputStreamTest {
    private byte[] data;
    private InputStream byteArrayInputStream;
    private InputStream shielded;
    private boolean closed;

    @BeforeEach
    public void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.byteArrayInputStream = new ByteArrayInputStream(this.data){

            @Override
            public void close() {
                CloseShieldInputStreamTest.this.closed = true;
            }
        };
        this.closed = false;
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        CloseShieldInputStream shadow;
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)this.byteArrayInputStream);){
            Assertions.assertEquals((int)3, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    public void testAvailableAfterOpen() throws Exception {
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)this.byteArrayInputStream);){
            Assertions.assertEquals((int)3, (int)in.available());
        }
    }

    @Test
    public void testClose() throws IOException {
        this.shielded = CloseShieldInputStream.wrap((InputStream)this.byteArrayInputStream);
        this.shielded.close();
        Assertions.assertFalse((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.shielded.read(), (String)"read()");
        Assertions.assertEquals((int)this.data[0], (int)this.byteArrayInputStream.read(), (String)"read()");
    }

    @Test
    public void testReadAfterCose() throws Exception {
        CloseShieldInputStream shadow;
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)this.byteArrayInputStream);){
            Assertions.assertEquals((int)3, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)shadow.read());
    }

    @Test
    public void testSystemInOnSystemInNo() throws IOException {
        this.shielded = CloseShieldInputStream.systemIn((InputStream)this.byteArrayInputStream);
        this.shielded.close();
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)this.data[0], (int)this.shielded.read(), (String)"read()");
        Assertions.assertEquals((int)this.data[1], (int)this.byteArrayInputStream.read(), (String)"read()");
    }

    @Test
    public void testSystemInOnSystemInYes() throws IOException {
        this.shielded = CloseShieldInputStream.systemIn((InputStream)System.in);
        this.shielded.close();
        Assertions.assertFalse((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.shielded.read(), (String)"read()");
        Assertions.assertEquals((int)this.data[0], (int)this.byteArrayInputStream.read(), (String)"read()");
    }
}

